/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.overlay;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.Toast;
import io.intercom.android.sdk.Intercom;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.activities.IntercomMessengerActivity;
import io.intercom.android.sdk.activities.IntercomNoteActivity;
import io.intercom.android.sdk.activities.IntercomPostActivity;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.conversation.SoundPlayer;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.events.ConfigUpdateEvent;
import io.intercom.android.sdk.models.events.FirstMessageEvent;
import io.intercom.android.sdk.models.events.ReadEvent;
import io.intercom.android.sdk.models.events.UnreadConversationsEvent;
import io.intercom.android.sdk.models.events.realtime.CreateConversationEvent;
import io.intercom.android.sdk.models.events.realtime.NewCommentEvent;
import io.intercom.android.sdk.overlay.DefaultLauncher;
import io.intercom.android.sdk.overlay.DefaultLauncherPresenter;
import io.intercom.android.sdk.overlay.InAppNotificationManager;
import io.intercom.android.sdk.overlay.LauncherOpenBehaviour;
import io.intercom.android.sdk.overlay.SystemSettings;
import io.intercom.android.sdk.state.OverlayState;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.ViewUtils;
import io.intercom.com.squareup.otto.Bus;
import io.intercom.com.squareup.otto.Subscribe;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OverlayManager
implements InAppNotificationManager.Listener,
Store.Subscriber<Integer> {
    private final List<Conversation> conversations = new ArrayList<Conversation>();
    private final Set<String> dismissedPartIds = new HashSet<String>();
    final DefaultLauncherPresenter launcherPresenter;
    final InAppNotificationManager inAppNotificationManager;
    private final SoundPlayer soundPlayer;
    private final MetricsStore metricsStore;
    private final MetricFactory metricFactory;
    private final Store<State> store;
    private final Application application;
    private final AppConfig.Provider appConfigProvider;
    private final Api.Provider apiProvider;
    private final Handler handler;
    private final float transitionScale;
    private final UserIdentity userIdentity;

    public OverlayManager(Application application, Bus bus, Store<State> store, AppConfig.Provider appConfigProvider, SoundPlayer soundPlayer, MetricsStore metricsStore, MetricFactory metricFactory, Api.Provider apiProvider, UserIdentity userIdentity) {
        this.application = application;
        this.apiProvider = apiProvider;
        this.appConfigProvider = appConfigProvider;
        this.store = store;
        this.soundPlayer = soundPlayer;
        this.metricsStore = metricsStore;
        this.metricFactory = metricFactory;
        this.userIdentity = userIdentity;
        LayoutInflater inflater = LayoutInflater.from((Context)application);
        this.handler = new Handler(Looper.getMainLooper());
        this.inAppNotificationManager = new InAppNotificationManager(inflater, this.handler, this, metricsStore, metricFactory);
        LauncherOpenBehaviour launcherOpenBehaviour = new LauncherOpenBehaviour(appConfigProvider, store, LauncherOpenBehaviour.LauncherType.DEFAULT, metricsStore, metricFactory);
        this.launcherPresenter = new DefaultLauncherPresenter(inflater, appConfigProvider, launcherOpenBehaviour, metricsStore, metricFactory);
        this.transitionScale = SystemSettings.getTransitionScale((Context)application);
        bus.register((Object)this);
        store.subscribeToChanges(Selectors.UNREAD_COUNT, this);
    }

    public void setInAppNotificationVisibility(Intercom.Visibility visibility) {
        this.store.dispatch(Actions.setInAppNotificationVisibility(visibility));
        this.refreshOverlayStates(visibility);
    }

    public void setLauncherVisibility(Intercom.Visibility visibility) {
        this.store.dispatch(Actions.setLauncherVisibility(visibility));
        this.refreshOverlayStates(visibility);
    }

    private void refreshOverlayStates(Intercom.Visibility visibility) {
        Activity hostActivity;
        if (visibility == Intercom.Visibility.GONE && (hostActivity = this.getState().resumedHostActivity()) != null) {
            this.removeOverlaysIfPresent(hostActivity);
        }
        this.conditionallyAddOverlays(this.conversations);
    }

    private void displayFirstMessageVisuals() {
        LayoutInflater inflater = LayoutInflater.from((Context)this.application);
        View view = inflater.inflate(R.layout.intercom_onboarding_layout, null);
        Toast toast = new Toast((Context)this.application);
        toast.setGravity(17, 0, 0);
        toast.setDuration(1);
        toast.setView(view);
        toast.show();
    }

    public void softRestart() {
        this.conditionallyAddOverlays(this.conversations);
    }

    public void softReset() {
        this.handler.removeCallbacksAndMessages(null);
        Activity hostActivity = this.getState().resumedHostActivity();
        if (hostActivity != null) {
            this.removeOverlaysIfPresent(hostActivity);
        }
    }

    public void hardReset() {
        this.conversations.clear();
        this.inAppNotificationManager.reset();
    }

    @Subscribe
    public void unreadConversationsReceived(UnreadConversationsEvent event) {
        IntercomLogger.internal("chathead", "received unread count update with: " + event.getResponse().getConversations() + " conversations and total unread count of " + event.getResponse().getUnreadConversationIds().size());
        this.conversations.clear();
        this.conversations.addAll(event.getResponse().getConversations());
        this.removeDismissedConversations(this.conversations, this.dismissedPartIds);
        this.removeBadgeConversations(this.conversations);
        this.conditionallyAddOverlays(this.conversations);
        for (Conversation conversation : event.getResponse().getConversations()) {
            Part lastPart = conversation.getLastPart();
            if (Part.DeliveryOption.SUMMARY == lastPart.getDeliveryOption()) {
                if (lastPart.isInitialMessage()) {
                    this.metricsStore.track(this.metricFactory.receivedMessageFromSnippetWhenClosed(lastPart.hasAttachments(), lastPart.isLinkCard(), conversation.getId(), lastPart.getId(), lastPart.getMessageStyle()));
                    continue;
                }
                this.metricsStore.track(this.metricFactory.receivedReplyFromSnippetWhenClosed(lastPart.hasAttachments(), lastPart.isLinkCard(), conversation.getId(), lastPart.getId()));
                continue;
            }
            this.metricsStore.track(this.metricFactory.receivedMessageFromFullWhenClosed(lastPart.hasAttachments(), lastPart.isLinkCard(), conversation.getId(), lastPart.getId(), lastPart.getMessageStyle()));
        }
    }

    @Subscribe
    public void configUpdated(ConfigUpdateEvent event) {
        OverlayState state = this.getState();
        if (this.shouldDisplayLauncher(this.conversations, state.notificationVisibility(), state.launcherVisibility(), state.resumedHostActivity())) {
            try {
                final ViewGroup root = this.getRootView();
                ViewUtils.waitForViewAttachment((View)root, new Runnable(){

                    @Override
                    public void run() {
                        OverlayManager.this.launcherPresenter.displayLauncherOnAttachedRoot(root);
                    }
                });
            }
            catch (Exception e) {
                IntercomLogger.internal("Couldn't display launcher: " + e.getMessage());
            }
        } else {
            this.launcherPresenter.updateLauncherBackground();
        }
    }

    @Subscribe
    public void conversationMarkedAsRead(ReadEvent event) {
        for (Conversation conversation : this.conversations) {
            if (!conversation.getId().equals(event.getConversationId())) continue;
            this.conversations.remove(conversation);
            break;
        }
        if (this.conversations.size() == 1 && this.store.state().unreadConversationIds().size() > this.conversations.size()) {
            this.apiProvider.getApi().getUnreadConversations();
        }
    }

    @Subscribe
    public void newComment(NewCommentEvent event) {
        this.fetchConversationsIfMessengerIsClosed();
    }

    @Subscribe
    public void newConversation(CreateConversationEvent event) {
        this.fetchConversationsIfMessengerIsClosed();
    }

    @Subscribe
    public void firstMessage(FirstMessageEvent event) {
        IntercomLogger.i(this.application.getString(R.string.intercom_activated_key_message));
        try {
            this.displayFirstMessageVisuals();
        }
        catch (Exception e) {
            IntercomLogger.internal("Couldn't first message: " + e.getMessage());
        }
    }

    private void fetchConversationsIfMessengerIsClosed() {
        if (this.getState().resumedHostActivity() != null) {
            this.apiProvider.getApi().getUnreadConversations();
        }
    }

    public void onActivityResumed() {
        this.conditionallyAddOverlays(this.conversations);
    }

    public void onActivityPaused(Activity activity) {
        this.handler.removeCallbacksAndMessages(null);
        this.removeOverlaysIfPresent(activity);
    }

    void conditionallyAddOverlays(final List<Conversation> conversations) {
        OverlayState state = this.getState();
        final Intercom.Visibility inAppVisibility = state.notificationVisibility();
        final Activity activity = state.resumedHostActivity();
        long expectedActivityLoadTime = (int)(500.0f * this.transitionScale);
        if (this.shouldDisplayNotifications(conversations, inAppVisibility, activity)) {
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (OverlayManager.this.shouldDisplayNotifications(conversations, inAppVisibility, activity)) {
                        OverlayManager.this.displayNotifications(conversations, inAppVisibility, activity);
                    }
                }
            }, expectedActivityLoadTime);
        } else {
            final Intercom.Visibility launcherVisibility = state.launcherVisibility();
            if (this.shouldDisplayLauncher(conversations, inAppVisibility, launcherVisibility, activity)) {
                this.handler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (OverlayManager.this.shouldDisplayLauncher(conversations, inAppVisibility, launcherVisibility, activity)) {
                            try {
                                final ViewGroup root = OverlayManager.this.getRootView();
                                ViewUtils.waitForViewAttachment((View)root, new Runnable(){

                                    @Override
                                    public void run() {
                                        OverlayManager.this.launcherPresenter.displayLauncherOnAttachedRoot(root);
                                    }
                                });
                            }
                            catch (Exception e) {
                                IntercomLogger.internal("Couldn't display launcher: " + e.getMessage());
                            }
                        }
                    }
                }, expectedActivityLoadTime);
            }
        }
    }

    void removeOverlaysIfPresent(Activity activity) {
        final View root = activity.findViewById(R.id.overlay_root);
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (root != null) {
                    OverlayManager.this.launcherPresenter.reset();
                    OverlayManager.this.inAppNotificationManager.reset();
                    if (root.getParent() != null) {
                        ((ViewGroup)root.getParent()).removeView(root);
                    }
                }
            }
        });
    }

    void displayNotifications(final List<Conversation> conversations, final Intercom.Visibility notificationVisibility, final Activity activity) {
        AvatarUtils.preloadAvatar(conversations.get(0).getLastAdmin().getAvatar(), (Context)activity, new Runnable(){

            @Override
            public void run() {
                if (OverlayManager.this.shouldDisplayNotifications(conversations, notificationVisibility, activity)) {
                    OverlayManager.this.displayNotificationsWithPreloadedAvatar(conversations);
                }
            }
        });
    }

    void displayNotificationsWithPreloadedAvatar(final List<Conversation> conversations) {
        ViewGroup rootView;
        try {
            rootView = this.getRootView();
        }
        catch (Exception ignored) {
            return;
        }
        Conversation conversation = conversations.get(0);
        String messageStyle = conversation.getLastPart().getMessageStyle();
        Part.DeliveryOption deliveryOption = conversation.getLastPart().getDeliveryOption();
        if (conversations.size() > 1 || this.inAppNotificationManager.isDisplaying() || deliveryOption == Part.DeliveryOption.SUMMARY || deliveryOption == Part.DeliveryOption.FULL && "chat".equals(messageStyle)) {
            this.soundPlayer.playAdminReplySound();
            if (this.launcherPresenter.isDisplaying()) {
                final DefaultLauncher defaultLauncher = this.launcherPresenter.getLauncher();
                if (conversations.size() == 1) {
                    defaultLauncher.pulseForTransformation((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            defaultLauncher.fadeOffScreen((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                                public void onAnimationEnd(Animator animation) {
                                    defaultLauncher.removeView();
                                }
                            });
                            OverlayManager.this.inAppNotificationManager.displayNotifications(rootView, conversations);
                        }
                    });
                } else {
                    defaultLauncher.fadeOffScreen((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            defaultLauncher.removeView();
                            OverlayManager.this.inAppNotificationManager.displayNotifications(rootView, conversations);
                        }
                    });
                }
            } else {
                this.inAppNotificationManager.displayNotifications(rootView, conversations);
            }
        } else if (deliveryOption == Part.DeliveryOption.FULL) {
            if ("post".equals(messageStyle)) {
                this.soundPlayer.playAdminReplySound();
                this.openPost(conversation, false);
            } else if ("note".equals(messageStyle)) {
                this.soundPlayer.playAdminReplySound();
                this.openNote(conversation, false);
            }
        }
    }

    @Override
    public ViewGroup getRootView() throws Exception {
        Activity activity = this.getState().resumedHostActivity();
        if (activity == null) {
            throw new NullPointerException();
        }
        ViewGroup root = (ViewGroup)activity.findViewById(R.id.overlay_root);
        if (root == null) {
            root = (ViewGroup)activity.getLayoutInflater().inflate(R.layout.intercom_overlay_container, null, false);
            activity.addContentView((View)root, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 80));
        }
        return root;
    }

    @Override
    public void markAsDismissed(Conversation conversation) {
        this.apiProvider.getApi().markConversationAsDismissed(conversation.getId());
        this.dismissedPartIds.add(conversation.getLastPart().getId());
        this.removeDismissedConversations(this.conversations, this.dismissedPartIds);
        OverlayState state = this.getState();
        if (this.shouldDisplayLauncher(this.conversations, state.notificationVisibility(), state.launcherVisibility(), state.resumedHostActivity())) {
            try {
                final ViewGroup root = this.getRootView();
                ViewUtils.waitForViewAttachment((View)root, new Runnable(){

                    @Override
                    public void run() {
                        OverlayManager.this.launcherPresenter.displayLauncherOnAttachedRoot(root);
                    }
                });
            }
            catch (Exception e) {
                IntercomLogger.internal("Couldn't display launcher: " + e.getMessage());
            }
        }
    }

    @Override
    public void openNotification(Conversation conversation) {
        Part lastPart = conversation.getLastAdminPart();
        String messageStyle = lastPart.getMessageStyle();
        if ("post".equals(messageStyle)) {
            this.openPost(conversation, true);
        } else if ("note".equals(messageStyle)) {
            this.openNote(conversation, true);
        } else {
            this.openMessenger(conversation);
            if ("chat".equals(messageStyle) && Part.DeliveryOption.FULL == lastPart.getDeliveryOption()) {
                this.metricsStore.track(this.metricFactory.openedConversationFromFull(conversation.getId(), lastPart.getId()));
            } else {
                this.metricsStore.track(this.metricFactory.openedConversationFromSnippet(conversation.getId(), lastPart.getId()));
            }
        }
    }

    private void openMessenger(Conversation conversation) {
        this.application.startActivity(IntercomMessengerActivity.openConversation((Context)this.application, conversation.getId(), conversation.getLastParticipatingAdmin()));
    }

    private void openPost(Conversation conversation, boolean openedFromSnippet) {
        Part lastPart = conversation.getLastPart();
        if (openedFromSnippet) {
            this.metricsStore.track(this.metricFactory.viewedInAppFromSnippet(conversation.getId(), lastPart.getId()));
        } else {
            this.metricsStore.track(this.metricFactory.viewedInAppFromFull(conversation.getId(), lastPart.getId()));
        }
        this.application.startActivity(IntercomPostActivity.buildPostIntent((Context)this.application, conversation.getLastPart(), conversation.getId(), conversation.getLastParticipatingAdmin(), true));
    }

    private void openNote(Conversation conversation, boolean openedFromSnippet) {
        Part lastPart = conversation.getLastPart();
        if (openedFromSnippet) {
            this.metricsStore.track(this.metricFactory.viewedInAppFromSnippet(conversation.getId(), lastPart.getId()));
        } else {
            this.metricsStore.track(this.metricFactory.viewedInAppFromFull(conversation.getId(), lastPart.getId()));
        }
        try {
            this.application.startActivity(IntercomNoteActivity.buildNoteIntent((Context)this.application, lastPart, conversation.getId(), conversation.getLastParticipatingAdmin()));
        }
        catch (IllegalArgumentException e) {
            IntercomLogger.internal("Overlay", "Error loading the note " + e.getMessage());
        }
    }

    boolean shouldDisplayNotifications(List<Conversation> conversations, Intercom.Visibility notificationVisibility, @Nullable Activity hostActivity) {
        return notificationVisibility == Intercom.Visibility.VISIBLE && !this.userIdentity.isSoftReset() && conversations != null && !conversations.isEmpty() && hostActivity != null;
    }

    boolean shouldDisplayLauncher(List<Conversation> conversations, Intercom.Visibility notificationVisibility, Intercom.Visibility launcherVisibility, @Nullable Activity hostActivity) {
        if (notificationVisibility == Intercom.Visibility.VISIBLE) {
            for (Conversation c : conversations) {
                if (Part.DeliveryOption.BADGE == c.getLastPart().getDeliveryOption()) continue;
                return false;
            }
        }
        return launcherVisibility == Intercom.Visibility.VISIBLE && !this.userIdentity.isSoftReset() && this.userIdentity.identityExists() && this.appConfigProvider.getAppConfig().isReceivedFromServer() && hostActivity != null;
    }

    private void removeDismissedConversations(List<Conversation> conversations, Set<String> dismissedPartIds) {
        for (int i = conversations.size() - 1; i >= 0; --i) {
            if (!dismissedPartIds.contains(conversations.get(i).getLastPart().getId())) continue;
            conversations.remove(i);
        }
    }

    private void removeBadgeConversations(List<Conversation> conversations) {
        for (int i = conversations.size() - 1; i >= 0; --i) {
            if (conversations.get(i).getLastPart().getDeliveryOption() != Part.DeliveryOption.BADGE) continue;
            conversations.remove(i);
        }
    }

    private OverlayState getState() {
        return this.store.select(Selectors.OVERLAY);
    }

    @Override
    public void onStateChange(Integer unreadCount) {
        this.launcherPresenter.setUnreadCount(unreadCount);
    }

    public static interface Provider {
        public OverlayManager getOverlayManager();
    }
}

