/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.overlay;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.utilities.BackgroundUtils;

class DefaultLauncher
implements View.OnTouchListener {
    private final TextView badgeCount;
    final View launcherRoot;
    final Listener listener;
    private final View badge;

    public DefaultLauncher(ViewGroup root, LayoutInflater inflater, Listener listener, @ColorInt int color2) {
        this.listener = listener;
        inflater.inflate(R.layout.intercom_default_launcher, root, true);
        this.launcherRoot = root.findViewById(R.id.launcher_root);
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.launcherRoot.getLayoutParams();
        params.setMargins(params.leftMargin, params.topMargin, params.rightMargin, params.bottomMargin + this.launcherRoot.getResources().getDimensionPixelSize(R.dimen.intercom_bottom_padding));
        this.launcherRoot.setLayoutParams((ViewGroup.LayoutParams)params);
        this.badge = this.launcherRoot.findViewById(R.id.launcher_icon);
        this.badgeCount = (TextView)this.launcherRoot.findViewById(R.id.launcher_badge_count);
        this.updateColor(color2);
        this.launcherRoot.setOnTouchListener((View.OnTouchListener)this);
    }

    public void updateColor(@ColorInt int color2) {
        Context context = this.badge.getContext();
        Drawable iconBg = ContextCompat.getDrawable((Context)context, (int)R.drawable.intercom_solid_circle);
        iconBg.setColorFilter(color2, PorterDuff.Mode.SRC_IN);
        Drawable countBg = iconBg.getConstantState().newDrawable();
        int countBackgroundColour = ContextCompat.getColor((Context)context, (int)R.color.intercom_inbox_count_background);
        countBg.setColorFilter(countBackgroundColour, PorterDuff.Mode.SRC_IN);
        BackgroundUtils.setBackground((View)this.badgeCount, countBg);
        BackgroundUtils.setBackground(this.badge, iconBg);
    }

    public void setBadgeCount(String unreadCount) {
        this.badgeCount.setVisibility(0);
        this.badgeCount.setText((CharSequence)unreadCount);
    }

    public void hideBadgeCount() {
        this.badgeCount.setVisibility(8);
    }

    public void fadeOnScreen() {
        this.launcherRoot.setAlpha(0.0f);
        this.launcherRoot.animate().alpha(1.0f).setDuration(100L).start();
    }

    public void fadeOffScreen(@Nullable Animator.AnimatorListener listener) {
        this.launcherRoot.animate().alpha(0.0f).setDuration(100L).setListener(listener).start();
    }

    public void pulseForTransformation(final Animator.AnimatorListener listener) {
        this.launcherRoot.animate().scaleX(1.1f).scaleY(1.1f).setDuration(100L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                listener.onAnimationEnd(animation);
                DefaultLauncher.this.launcherRoot.animate().scaleX(1.0f).scaleY(1.0f).setDuration(100L).start();
            }
        }).start();
    }

    public void removeView() {
        if (this.launcherRoot.getParent() != null) {
            ((ViewGroup)this.launcherRoot.getParent()).removeView(this.launcherRoot);
        }
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                v.setScaleX(0.9f);
                v.setScaleY(0.9f);
                break;
            }
            case 1: {
                this.callListenerWithFadeOut();
                break;
            }
        }
        return true;
    }

    private void callListenerWithFadeOut() {
        this.launcherRoot.setAlpha(1.0f);
        this.launcherRoot.animate().alpha(0.0f).setDuration(50L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                DefaultLauncher.this.listener.onLauncherClicked(DefaultLauncher.this.launcherRoot.getContext());
            }
        }).start();
    }

    public static interface Listener {
        public void onLauncherClicked(Context var1);
    }
}

