/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.inbox;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.design.widget.FloatingActionButton;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.Property;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.inbox.ConversationClickListener;
import io.intercom.android.sdk.inbox.InboxAdapter;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.events.realtime.CreateConversationEvent;
import io.intercom.android.sdk.models.events.realtime.NewCommentEvent;
import io.intercom.android.sdk.state.InboxState;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.utilities.Phrase;
import io.intercom.android.sdk.utilities.StoreUtils;
import io.intercom.android.sdk.utilities.TimeFormatter;
import io.intercom.android.sdk.utilities.ViewUtils;
import io.intercom.android.sdk.views.EndlessRecyclerScrollListener;
import io.intercom.android.sdk.views.EndlessScrollListener;
import io.intercom.android.sdk.views.IntercomErrorView;
import io.intercom.android.sdk.views.IntercomToolbar;
import io.intercom.com.squareup.otto.Subscribe;
import java.util.List;

public class InboxFragment
extends Fragment
implements View.OnClickListener,
ConversationClickListener,
EndlessScrollListener,
IntercomToolbar.Listener,
Store.Subscriber<InboxState> {
    private static final String ARG_IS_TWO_PANE = "is_two_pane";
    private IntercomToolbar intercomToolbar;
    private View rootView;
    @VisibleForTesting
    RecyclerView inboxView;
    private IntercomErrorView inboxErrorView;
    private FloatingActionButton composerButton;
    private ProgressBar progressBar;
    private LinearLayoutManager layoutManager;
    private EndlessRecyclerScrollListener endlessRecyclerScrollListener;
    Listener listener;
    private InboxAdapter adapter;
    private Store<State> store;
    private MetricFactory metricFactory;
    private MetricsStore metricStore;
    private String openConversationId = "";
    private boolean isTwoPane = false;
    @Nullable
    private Store.Subscription subscription;

    public static InboxFragment newInstance(boolean isTwoPane) {
        InboxFragment fragment = new InboxFragment();
        Bundle args = new Bundle();
        args.putBoolean(ARG_IS_TWO_PANE, isTwoPane);
        fragment.setArguments(args);
        return fragment;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            this.listener = (Listener)context;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(context + " must implement InboxFragment.Listener");
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Injector injector = Injector.get();
        this.store = injector.getStore();
        FragmentActivity activity = this.getActivity();
        this.adapter = new InboxAdapter(LayoutInflater.from((Context)activity), this, this.store, new TimeFormatter((Context)activity, injector.getTimeProvider()));
        this.layoutManager = new LinearLayoutManager((Context)activity);
        this.endlessRecyclerScrollListener = new EndlessRecyclerScrollListener(this.layoutManager, this);
        UserIdentity userIdentity = injector.getUserIdentity();
        this.metricFactory = new MetricFactory(userIdentity);
        this.metricStore = injector.getMetricsStore();
        injector.getBus().register((Object)this);
        Bundle args = this.getArguments();
        if (args != null) {
            this.isTwoPane = args.getBoolean(ARG_IS_TWO_PANE, false);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        IntercomLogger.internal("inbox frag", "creating view for fragment");
        if (this.rootView == null) {
            this.rootView = inflater.inflate(R.layout.intercom_fragment_inbox, container, false);
            this.intercomToolbar = (IntercomToolbar)this.rootView.findViewById(R.id.intercom_toolbar);
            this.inboxErrorView = (IntercomErrorView)this.rootView.findViewById(R.id.error_layout_inbox);
            this.inboxView = (RecyclerView)this.rootView.findViewById(R.id.inbox_recycler_view);
            this.composerButton = (FloatingActionButton)this.rootView.findViewById(R.id.compose_action_button);
            this.progressBar = (ProgressBar)this.rootView.findViewById(R.id.progressBar);
            this.inboxView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
            this.inboxView.addOnScrollListener((RecyclerView.OnScrollListener)this.endlessRecyclerScrollListener);
            this.inboxView.setAdapter((RecyclerView.Adapter)this.adapter);
            this.composerButton.setOnClickListener((View.OnClickListener)this);
            this.inboxErrorView.setActionButtonClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    InboxFragment.this.fetchNewConversations();
                }
            });
            this.intercomToolbar.setListener(this);
            this.intercomToolbar.setSubtitleVisibility(8);
            if (this.isTwoPane) {
                this.intercomToolbar.setCloseButtonVisibility(8);
            }
            AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable(){

                @Override
                public void run() {
                    InboxFragment.this.fetchNewConversations();
                }
            });
        } else {
            ViewGroup parent = (ViewGroup)this.rootView.getParent();
            if (parent != null) {
                parent.removeView(this.rootView);
            }
        }
        this.openConversationId = "";
        return this.rootView;
    }

    void fetchNewConversations() {
        this.store.dispatch(Actions.fetchInboxRequest());
        Injector.get().getApi().getInbox();
    }

    private boolean isInboundMessageEnabled() {
        return Injector.get().getAppIdentity().getAppConfig().isInboundMessages();
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.subscription = this.store.subscribeToChanges(Selectors.INBOX, this);
    }

    public void onDestroyView() {
        StoreUtils.safeUnsubscribe(this.subscription);
        super.onDestroyView();
    }

    public void onResume() {
        this.store.dispatch(Actions.inboxOpened());
        if (!this.isTwoPane) {
            this.inboxView.setAlpha(1.0f);
        }
        this.setToolbarTitle();
        this.setColorScheme();
        super.onResume();
    }

    private void setToolbarTitle() {
        String appName = Injector.get().getAppIdentity().getAppConfig().getName();
        if (TextUtils.isEmpty((CharSequence)appName)) {
            this.intercomToolbar.setTitle(this.getString(R.string.intercom_chats));
        } else {
            CharSequence title = Phrase.from(this.getContext(), R.string.intercom_chats_with).put("name", appName).format();
            this.intercomToolbar.setTitle(title);
        }
    }

    private void setColorScheme() {
        int baseColor = Injector.get().getAppIdentity().getAppConfig().getBaseColor();
        this.progressBar.getIndeterminateDrawable().setColorFilter(baseColor, PorterDuff.Mode.SRC_IN);
        this.composerButton.setBackgroundTintList(ColorStateList.valueOf((int)baseColor));
        this.listener.setStatusBarColor();
        this.intercomToolbar.setBackgroundColor(baseColor);
    }

    public void onDestroy() {
        Injector.get().getBus().unregister((Object)this);
        super.onDestroy();
    }

    public void onDetach() {
        super.onDetach();
        this.listener = null;
    }

    public void onClick(View view) {
        if (view.getId() == R.id.compose_action_button) {
            if (this.isTwoPane) {
                this.listener.onComposerSelected();
            } else {
                this.fadeOutInbox(new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        InboxFragment.this.listener.onComposerSelected();
                    }
                });
            }
            this.metricStore.track(this.metricFactory.newConversationFromComposeButton());
        }
    }

    private void fadeOutInbox(AnimatorListenerAdapter endListener) {
        this.intercomToolbar.fadeOutInbox();
        ObjectAnimator animator2 = ObjectAnimator.ofFloat((Object)this.inboxView, (Property)View.ALPHA, (float[])new float[]{this.inboxView.getAlpha(), 0.0f}).setDuration(150L);
        animator2.addListener((Animator.AnimatorListener)endListener);
        animator2.start();
    }

    @Override
    public void onConversationClicked(int position) {
        final Conversation conversation = this.store.state().inboxState().conversations().get(position);
        this.openConversationId = conversation.getId();
        if (this.isTwoPane) {
            this.listener.onConversationSelected(conversation);
        } else {
            this.fadeOutInbox(new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    InboxFragment.this.listener.onConversationSelected(conversation);
                }
            });
        }
        this.metricStore.track(this.metricFactory.openConversationFromConversationList(conversation.getId()));
    }

    @Override
    public void onLoadMore() {
        InboxState inboxState = this.store.state().inboxState();
        List<Conversation> conversations = inboxState.conversations();
        if (inboxState.status() == InboxState.Status.LOADING || conversations.isEmpty()) {
            return;
        }
        Conversation conversation = conversations.get(conversations.size() - 1);
        this.store.dispatch(Actions.fetchInboxRequest());
        Injector.get().getApi().getInboxBefore(conversation.getLastPart().getCreatedAt());
    }

    @Override
    public void setOverScrollColour() {
        ViewUtils.setOverScrollColour(this.inboxView, Injector.get().getAppIdentity().getAppConfig().getBaseColor());
    }

    @Override
    public void onCloseClicked() {
        this.listener.onToolbarCloseClicked();
    }

    @Override
    public void onToolbarClicked() {
    }

    @Override
    public void onInboxClicked() {
    }

    @Override
    public void onStateChange(InboxState inboxState) {
        if (!this.isAdded()) {
            return;
        }
        switch (inboxState.status()) {
            case INITIAL: {
                this.displayLoadingView();
                break;
            }
            case LOADING: {
                if (inboxState.conversations().isEmpty()) {
                    this.displayLoadingView();
                    break;
                }
                this.displayInbox();
                break;
            }
            case SUCCESS: {
                if (this.layoutManager.findFirstCompletelyVisibleItemPosition() == 0) {
                    this.layoutManager.scrollToPosition(0);
                }
                if (inboxState.conversations().isEmpty()) {
                    this.displayEmptyView();
                } else {
                    this.displayInbox();
                }
                this.listener.onConversationsLoaded(inboxState.conversations(), inboxState.status());
                break;
            }
            default: {
                this.displayErrorView();
            }
        }
        this.adapter.setInboxState(inboxState);
        this.adapter.notifyDataSetChanged();
        this.endlessRecyclerScrollListener.setMorePagesAvailable(inboxState.hasMorePages());
    }

    private void displayLoadingView() {
        this.inboxErrorView.setVisibility(8);
        this.inboxView.setVisibility(8);
        this.composerButton.setVisibility(8);
        this.progressBar.setVisibility(0);
    }

    private void displayInbox() {
        this.inboxView.setVisibility(0);
        this.showComposerButtonIfEnabled();
        this.inboxErrorView.setVisibility(8);
        this.progressBar.setVisibility(8);
    }

    private void displayEmptyView() {
        this.inboxErrorView.setTitle(R.string.intercom_no_messages);
        CharSequence subtitle = Phrase.from(this.getContext(), R.string.intercom_empty_conversations).put("name", Injector.get().getAppIdentity().getAppConfig().getName()).format();
        this.inboxErrorView.setSubtitle(subtitle);
        this.inboxErrorView.setActionButtonVisibility(8);
        this.inboxErrorView.setVisibility(0);
        this.showComposerButtonIfEnabled();
        this.inboxView.setVisibility(8);
        this.progressBar.setVisibility(8);
    }

    private void showComposerButtonIfEnabled() {
        this.composerButton.setVisibility(this.isInboundMessageEnabled() ? 0 : 8);
    }

    private void displayErrorView() {
        this.inboxErrorView.setTitle(R.string.intercom_inbox_error_state_title);
        this.inboxErrorView.setSubtitle(R.string.intercom_conversation_error_state_subtitle);
        this.inboxErrorView.setActionButtonText(R.string.intercom_tap_to_retry);
        this.inboxErrorView.setActionButtonVisibility(0);
        this.inboxErrorView.setVisibility(0);
        this.inboxView.setVisibility(8);
        this.progressBar.setVisibility(8);
        this.composerButton.setVisibility(8);
    }

    @Subscribe
    public void newComment(NewCommentEvent event) {
        if (!event.getConversationId().equals(this.openConversationId)) {
            this.fetchNewConversations();
        }
    }

    @Subscribe
    public void newConversation(CreateConversationEvent event) {
        this.fetchNewConversations();
    }

    public static interface Listener {
        public void onConversationsLoaded(List<Conversation> var1, InboxState.Status var2);

        public void onConversationSelected(Conversation var1);

        public void onComposerSelected();

        public void setStatusBarColor();

        public void onToolbarCloseClicked();
    }
}

