/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.overlay;

import android.content.Context;
import android.text.TextUtils;
import io.intercom.android.sdk.activities.IntercomMessengerActivity;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.state.UiState;
import io.intercom.android.sdk.store.Store;
import java.util.Set;

public class LauncherOpenBehaviour {
    private final AppConfig.Provider appConfigProvider;
    private final Store<State> store;
    private final LauncherType launcherType;
    private final MetricsStore metricsStore;
    private final MetricFactory metricFactory;

    public LauncherOpenBehaviour(AppConfig.Provider appConfigProvider, Store<State> store, LauncherType launcherType, MetricsStore metricsStore, MetricFactory metricFactory) {
        this.appConfigProvider = appConfigProvider;
        this.store = store;
        this.launcherType = launcherType;
        this.metricsStore = metricsStore;
        this.metricFactory = metricFactory;
    }

    public void openMessenger(Context context) {
        Set<String> unreadConversationIds = this.store.state().unreadConversationIds();
        if (unreadConversationIds.size() == 1) {
            this.presentConversation(context, unreadConversationIds.iterator().next());
        } else if (unreadConversationIds.size() > 1) {
            this.presentInbox(context);
        } else {
            this.openLastOrDefaultState(context);
        }
    }

    private void openLastOrDefaultState(Context context) {
        UiState uiState = this.store.state().uiState();
        switch (uiState.screen()) {
            case CONVERSATION: {
                String lastViewedConversationId = uiState.conversationId();
                if (TextUtils.isEmpty((CharSequence)lastViewedConversationId)) {
                    this.presentInbox(context);
                    break;
                }
                this.presentConversation(context, lastViewedConversationId);
                break;
            }
            default: {
                this.presentInbox(context);
                break;
            }
            case COMPOSER: {
                this.presentComposer(context);
                break;
            }
            case NONE: {
                if (this.hasEmptyInbox() && this.appConfigProvider.getAppConfig().isInboundMessages()) {
                    this.presentComposer(context);
                    break;
                }
                this.presentInbox(context);
            }
        }
    }

    private boolean hasEmptyInbox() {
        State state = this.store.state();
        return Boolean.FALSE.equals(state.hasConversations()) && state.unreadConversationIds().isEmpty();
    }

    private void presentConversation(Context context, String conversationId) {
        this.metricsStore.track(this.metricFactory.openedMessengerConversation(conversationId, this.launcherType));
        LastParticipatingAdmin unknownAdmin = LastParticipatingAdmin.NULL;
        context.startActivity(IntercomMessengerActivity.openConversation(context, conversationId, unknownAdmin));
    }

    private void presentComposer(Context context) {
        this.metricsStore.track(this.metricFactory.openedMessengerNewConversation(this.launcherType));
        context.startActivity(IntercomMessengerActivity.openComposer(context, ""));
    }

    private void presentInbox(Context context) {
        this.metricsStore.track(this.metricFactory.openedMessengerConversationList(this.launcherType));
        context.startActivity(IntercomMessengerActivity.openInbox(context));
    }

    public static enum LauncherType {
        DEFAULT,
        CUSTOM;

    }
}

