/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.overlay;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.overlay.DefaultLauncher;
import io.intercom.android.sdk.overlay.LauncherOpenBehaviour;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.utilities.StoreUtils;

class DefaultLauncherManager
implements DefaultLauncher.Listener,
Store.Subscriber<Integer> {
    private final LayoutInflater inflater;
    private final AppConfig.Provider appConfigProvider;
    private final LauncherOpenBehaviour openBehaviour;
    private final Store<State> store;
    private final MetricsStore metricsStore;
    private final MetricFactory metricFactory;
    @Nullable
    private DefaultLauncher defaultLauncher;
    @Nullable
    private Store.Subscription subscription;
    private int previousUnreadCount = 0;

    DefaultLauncherManager(LayoutInflater inflater, Store<State> store, AppConfig.Provider appConfigProvider, LauncherOpenBehaviour openBehaviour, MetricsStore metricsStore, MetricFactory metricFactory) {
        this.inflater = inflater;
        this.store = store;
        this.appConfigProvider = appConfigProvider;
        this.openBehaviour = openBehaviour;
        this.metricsStore = metricsStore;
        this.metricFactory = metricFactory;
    }

    void displayLauncherOnAttachedRoot(ViewGroup root) {
        if (this.defaultLauncher == null) {
            this.defaultLauncher = new DefaultLauncher(root, this.inflater, this.appConfigProvider, this);
            this.defaultLauncher.fadeOnScreen();
        }
        StoreUtils.safeUnsubscribe(this.subscription);
        this.subscription = this.store.subscribeToChanges(Selectors.UNREAD_COUNT, this);
    }

    DefaultLauncher getLauncher() {
        DefaultLauncher localLauncher = this.defaultLauncher;
        this.defaultLauncher = null;
        return localLauncher;
    }

    public void updateLauncherBackground() {
        if (this.defaultLauncher != null) {
            this.defaultLauncher.updateBackgrounds(this.appConfigProvider);
        }
    }

    public void reset() {
        StoreUtils.safeUnsubscribe(this.subscription);
        this.removeLauncher();
    }

    @VisibleForTesting
    void removeLauncher() {
        if (this.defaultLauncher != null) {
            this.defaultLauncher.fadeOffScreen(null);
            this.defaultLauncher = null;
        }
    }

    public boolean isDisplaying() {
        return this.defaultLauncher != null;
    }

    @Override
    public void onStateChange(Integer unreadCount) {
        this.setUnreadCount(unreadCount);
    }

    private void setUnreadCount(int unreadCount) {
        String unreadCountText = String.valueOf(unreadCount);
        if (this.isDisplaying()) {
            if (unreadCount > this.previousUnreadCount) {
                this.metricsStore.track(this.metricFactory.receivedNotificationFromBadgeWhenMessengerClosed(unreadCountText));
            }
            if (unreadCount > 0) {
                this.defaultLauncher.setBadgeCount(unreadCountText);
            } else {
                this.defaultLauncher.hideBadgeCount();
            }
        }
        this.previousUnreadCount = unreadCount;
    }

    @Override
    public void onLauncherClicked(Context context) {
        this.openBehaviour.openMessenger(context);
    }
}

