/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.commons.utilities.TimeProvider;
import io.intercom.android.sdk.identity.AppIdentity;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DeDuper {
    private static final String CUSTOM_ATTRIBUTES = "custom_attributes";
    private final Map<String, Object> cachedAttributes = new HashMap<String, Object>();
    private final AppIdentity appIdentity;
    private long earliestUpdateAt = 0L;

    public DeDuper(AppIdentity appIdentity) {
        this.appIdentity = appIdentity;
    }

    public void update(Map<String, ?> newAttributes) {
        if (this.hasExpiredCache()) {
            this.cachedAttributes.clear();
            this.setEarliestUpdateAt(TimeProvider.SYSTEM.currentTimeMillis());
        }
        if (this.earliestUpdateAt == 0L) {
            this.setEarliestUpdateAt(TimeProvider.SYSTEM.currentTimeMillis());
        }
        Map<String, Object> cachedCustomAttributes = DeDuper.getCustomAttributes(this.cachedAttributes);
        Map<String, Object> newCustomAttributes = DeDuper.getCustomAttributes(newAttributes);
        this.cachedAttributes.putAll(newAttributes);
        if (cachedCustomAttributes != null && newCustomAttributes != null) {
            this.cachedAttributes.put(CUSTOM_ATTRIBUTES, DeDuper.mergeMaps(cachedCustomAttributes, newCustomAttributes));
        }
    }

    public boolean shouldUpdateUser(Map<String, Object> newAttributes) {
        if (newAttributes.isEmpty() || DeDuper.containsOnlyEmptyCustomAttributes(newAttributes)) {
            return false;
        }
        return this.hasNewAttributeValues(newAttributes) || this.isEmpty() || this.hasExpiredCache();
    }

    private static boolean containsOnlyEmptyCustomAttributes(Map<String, Object> newAttributes) {
        return newAttributes.size() == 1 && Collections.EMPTY_MAP.equals(newAttributes.get(CUSTOM_ATTRIBUTES));
    }

    public void reset() {
        this.cachedAttributes.clear();
        this.earliestUpdateAt = 0L;
    }

    private boolean isEmpty() {
        return this.cachedAttributes.isEmpty();
    }

    private boolean hasExpiredCache() {
        if (this.earliestUpdateAt == 0L) {
            return false;
        }
        long cacheExpiryMillis = this.appIdentity.getAppConfig().getUserUpdateCacheMaxAgeMs();
        return TimeProvider.SYSTEM.currentTimeMillis() - this.earliestUpdateAt > cacheExpiryMillis;
    }

    private boolean hasNewAttributeValues(Map<String, Object> newAttributes) {
        Object newValue;
        Map<String, Object> cachedCustomAttributes = DeDuper.getCustomAttributes(this.cachedAttributes);
        Map<String, Object> newCustomAttributes = DeDuper.getCustomAttributes(newAttributes);
        if (newCustomAttributes != null) {
            if (cachedCustomAttributes == null) {
                return true;
            }
            for (Map.Entry<String, Object> newEntry : newCustomAttributes.entrySet()) {
                newValue = newEntry.getValue();
                if (newValue == null || newValue.equals(cachedCustomAttributes.get(newEntry.getKey()))) continue;
                return true;
            }
        }
        for (Map.Entry<String, Object> newEntry : newAttributes.entrySet()) {
            if (CUSTOM_ATTRIBUTES.equals(newEntry.getKey()) || (newValue = newEntry.getValue()) == null || newValue.equals(this.cachedAttributes.get(newEntry.getKey()))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static Map<String, Object> getCustomAttributes(Map<String, ?> map) {
        Object attributes = map.get(CUSTOM_ATTRIBUTES);
        return attributes instanceof Map ? (Map)attributes : null;
    }

    private static Map<String, Object> mergeMaps(Map<String, ?> currentMap, Map<String, ?> newMap) {
        HashMap<String, Object> mergedMap = new HashMap<String, Object>(currentMap);
        mergedMap.putAll(newMap);
        return mergedMap;
    }

    @VisibleForTesting
    Map<String, Object> getMap() {
        return this.cachedAttributes;
    }

    @VisibleForTesting
    void setEarliestUpdateAt(long time) {
        this.earliestUpdateAt = time;
    }

    @VisibleForTesting
    long getEarliestUpdateAt() {
        return this.earliestUpdateAt;
    }
}

