/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.animation.Animator;
import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;

public class BackgroundUtils {
    public static void setBackground(View background, Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 16) {
            background.setBackground(drawable2);
        } else {
            background.setBackgroundDrawable(drawable2);
        }
    }

    public static void animateBackground(int colorFrom, int colorTo, int duration, final View view, Animator.AnimatorListener animatationListener) {
        ValueAnimator colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{colorFrom, colorTo});
        colorAnimation.setDuration((long)duration);
        colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator2) {
                view.setBackgroundColor(((Integer)animator2.getAnimatedValue()).intValue());
            }
        });
        if (animatationListener != null) {
            colorAnimation.addListener(animatationListener);
        }
        colorAnimation.start();
    }
}

