/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class UserUpdater {
    private static final String CUSTOM_ATTRIBUTES = "custom_attributes";
    private final Handler handler;
    private final Api.Provider apiProvider;
    private final AppConfig.Provider appConfigProvider;
    private final Store<State> store;
    private Map<String, Object> pendingAttributes = new HashMap<String, Object>();
    private int batchSize = 0;
    private boolean allRequestsInBackground = true;

    public static UserUpdater create(Api.Provider apiProvider, AppConfig.Provider appConfigProvider, Store<State> store) {
        return new UserUpdater(new Handler(Looper.getMainLooper()), apiProvider, appConfigProvider, store);
    }

    @VisibleForTesting
    UserUpdater(Handler handler, Api.Provider apiProvider, AppConfig.Provider appConfigProvider, Store<State> store) {
        this.apiProvider = apiProvider;
        this.handler = handler;
        this.appConfigProvider = appConfigProvider;
        this.store = store;
    }

    public synchronized void submitPendingUpdates() {
        if (this.pendingAttributes.isEmpty()) {
            return;
        }
        Map<String, Object> currentAttributes = this.pendingAttributes;
        int currentBatchSize = this.batchSize;
        this.pendingAttributes = new HashMap<String, Object>();
        this.batchSize = 0;
        this.apiProvider.getApi().updateUser(currentAttributes, currentBatchSize, this.allRequestsInBackground);
        this.allRequestsInBackground = true;
    }

    public synchronized void updateUserWithAttributes(Map<String, Object> attributes) {
        if (this.updatesWillOverwritePendingUpdates(attributes)) {
            this.submitPendingUpdates();
        }
        this.addPendingUpdates(attributes);
    }

    private boolean updatesWillOverwritePendingUpdates(Map<String, Object> newAttributes) {
        Object newValue;
        Map<String, Object> existingCustomAttributes = UserUpdater.getCustomAttributes(this.pendingAttributes);
        Map<String, Object> newCustomAttributes = UserUpdater.getCustomAttributes(newAttributes);
        if (existingCustomAttributes != null && newCustomAttributes != null) {
            for (Map.Entry<String, Object> existingAttribute : existingCustomAttributes.entrySet()) {
                newValue = newCustomAttributes.get(existingAttribute.getKey());
                if (newValue == null || newValue.equals(existingAttribute.getValue())) continue;
                return true;
            }
        }
        for (Map.Entry<String, Object> existingAttribute : this.pendingAttributes.entrySet()) {
            if (CUSTOM_ATTRIBUTES.equals(existingAttribute.getKey()) || (newValue = newAttributes.get(existingAttribute.getKey())) == null || newValue.equals(existingAttribute.getValue())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static Map<String, Object> getCustomAttributes(Map<String, Object> map) {
        Object value = map.get(CUSTOM_ATTRIBUTES);
        return value instanceof Map ? (Map)value : null;
    }

    private void addPendingUpdates(Map<String, Object> newAttributes) {
        boolean shouldScheduleUpdate = this.pendingAttributes.isEmpty();
        this.mergeIntoPendingAttributes(newAttributes);
        ++this.batchSize;
        this.allRequestsInBackground &= this.store.select(Selectors.IS_BACKGROUNDED).booleanValue();
        if (shouldScheduleUpdate) {
            this.submitPendingUpdatesWithDelay(this.appConfigProvider.getAppConfig().getBatchUserUpdatePeriodMs());
        }
    }

    private void mergeIntoPendingAttributes(Map<String, Object> newAttributes) {
        HashMap<String, Object> existingCustomAttributes = UserUpdater.getCustomAttributes(this.pendingAttributes);
        Map<String, Object> newCustomAttributes = UserUpdater.getCustomAttributes(newAttributes);
        this.pendingAttributes.putAll(newAttributes);
        if (newCustomAttributes != null && !newCustomAttributes.isEmpty()) {
            HashMap<String, Object> customAttributes = existingCustomAttributes == null ? new HashMap<String, Object>() : existingCustomAttributes;
            customAttributes.putAll(newCustomAttributes);
            this.pendingAttributes.put(CUSTOM_ATTRIBUTES, customAttributes);
        } else if (existingCustomAttributes != null) {
            this.pendingAttributes.put(CUSTOM_ATTRIBUTES, existingCustomAttributes);
        } else {
            this.pendingAttributes.remove(CUSTOM_ATTRIBUTES);
        }
    }

    private void submitPendingUpdatesWithDelay(long delayMillis) {
        if (delayMillis > 0L) {
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    UserUpdater.this.submitPendingUpdates();
                }
            }, delayMillis);
        } else {
            this.submitPendingUpdates();
        }
    }
}

