/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.push;

import android.content.Context;
import android.os.Bundle;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.push.IntercomNotificationManager;
import io.intercom.android.sdk.push.PushNotification;
import io.intercom.android.sdk.user.DeviceData;

class IntercomPushHandler {
    private static final String TAG = "IntercomPushHandler";

    IntercomPushHandler() {
    }

    boolean shouldSendDeviceToken(Context context, String token) {
        return !DeviceData.hasCachedDeviceToken(context, token);
    }

    void sendTokenToIntercom(Context context, String token, Api api) {
        api.setDeviceToken(token);
        DeviceData.cacheDeviceToken(context, token);
    }

    void handlePush(Bundle message, UserIdentity userIdentity, IntercomNotificationManager notificationManager, MetricsStore metricsStore, boolean appBackgrounded, Context localisedContext, MetricFactory metricFactory) {
        if (userIdentity.identityExists()) {
            this.sendNotification(message, notificationManager, metricsStore, appBackgrounded, localisedContext, metricFactory);
        } else {
            notificationManager.killNotifications();
            IntercomLogger.i("Can't create push message as we have no user identity. This can be caused by messages being sent to a logged out user.");
        }
    }

    boolean isIntercomPush(Bundle message) {
        PushNotification notification = new PushNotification(message);
        return notification.isIntercomPush();
    }

    private void sendNotification(Bundle message, IntercomNotificationManager intercomNotificationManager, MetricsStore metricsStore, boolean appBackgrounded, Context localisedContext, MetricFactory metricFactory) {
        if (message != null && !message.isEmpty()) {
            IntercomLogger.internal(TAG, "Notification Data Json :" + message.getString("message"));
            PushNotification notification = new PushNotification(message);
            if (notification.isIntercomPush()) {
                if (notification.isPushOnly()) {
                    String conversationId = notification.getPushOnlyConversationId();
                    metricsStore.track(metricFactory.receivedPushOnlyNotification(conversationId));
                    intercomNotificationManager.createPushOnlyNotification(notification, localisedContext);
                } else if (appBackgrounded) {
                    metricsStore.track(metricFactory.receivedPushNotification(notification.getConversationId()));
                    intercomNotificationManager.createNotification(notification, localisedContext);
                } else {
                    IntercomLogger.i("Intercom message received but not displayed in notification bar. This happened because the host app was in the foreground.");
                }
            } else {
                IntercomLogger.i("This is not a Intercom push message");
            }
        } else {
            IntercomLogger.e("The push intent contained no data");
        }
    }
}

