/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.preview;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.Toast;
import io.intercom.android.sdk.Intercom;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.activities.IntercomMessengerActivity;
import io.intercom.android.sdk.activities.IntercomNoteActivity;
import io.intercom.android.sdk.activities.IntercomPostActivity;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.conversation.SoundPlayer;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.events.ConfigUpdateEvent;
import io.intercom.android.sdk.models.events.FirstMessageEvent;
import io.intercom.android.sdk.models.events.ReadEvent;
import io.intercom.android.sdk.models.events.UnreadConversationsEvent;
import io.intercom.android.sdk.models.events.realtime.CreateConversationEvent;
import io.intercom.android.sdk.models.events.realtime.NewCommentEvent;
import io.intercom.android.sdk.preview.DefaultLauncherManager;
import io.intercom.android.sdk.preview.LauncherOpenBehaviour;
import io.intercom.android.sdk.preview.NotificationManager;
import io.intercom.android.sdk.preview.PreviewInteractionManager;
import io.intercom.android.sdk.preview.SimpleActivityLifecycleCallbacks;
import io.intercom.android.sdk.preview.SystemSettings;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.IntercomUtils;
import io.intercom.android.sdk.utilities.ViewUtils;
import io.intercom.com.squareup.otto.Bus;
import io.intercom.com.squareup.otto.Subscribe;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PreviewManager
extends SimpleActivityLifecycleCallbacks
implements PreviewInteractionManager {
    private final List<Conversation> conversations = new ArrayList<Conversation>();
    private final Set<String> dismissedPartIds = new HashSet<String>();
    final DefaultLauncherManager defaultLauncherManager;
    final NotificationManager notificationManager;
    private final SoundPlayer soundPlayer;
    private final MetricsStore metricsStore;
    private final MetricFactory metricFactory;
    private final Store<State> store;
    private final Application application;
    private final AppConfig.Provider appConfigProvider;
    private final Api api;
    private final Handler handler;
    private final float transitionScale;
    private final UserIdentity userIdentity;
    private Intercom.Visibility previewVisibility = Intercom.Visibility.VISIBLE;
    private Intercom.Visibility launcherVisibility = Intercom.Visibility.GONE;
    @Nullable
    Activity lastActive;

    public PreviewManager(Application application, Bus bus, Store<State> store, AppConfig.Provider appConfigProvider, SoundPlayer soundPlayer, MetricsStore metricsStore, MetricFactory metricFactory, Api api, UserIdentity userIdentity) {
        this.application = application;
        this.api = api;
        this.appConfigProvider = appConfigProvider;
        this.store = store;
        this.soundPlayer = soundPlayer;
        this.metricsStore = metricsStore;
        this.metricFactory = metricFactory;
        this.userIdentity = userIdentity;
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        bus.register((Object)this);
        LayoutInflater inflater = LayoutInflater.from((Context)application);
        this.handler = new Handler(Looper.getMainLooper());
        this.notificationManager = new NotificationManager(inflater, this.handler, this, metricsStore, metricFactory);
        LauncherOpenBehaviour launcherOpenBehaviour = new LauncherOpenBehaviour(appConfigProvider, store, LauncherOpenBehaviour.LauncherType.DEFAULT, metricsStore, metricFactory);
        this.defaultLauncherManager = new DefaultLauncherManager(inflater, store, appConfigProvider, launcherOpenBehaviour, metricsStore, metricFactory);
        this.transitionScale = SystemSettings.getTransitionScale((Context)application);
    }

    public void setPreviewVisibility(Intercom.Visibility visibility) {
        this.previewVisibility = visibility;
        this.refreshOverlayStates(visibility);
    }

    public void setLauncherVisibility(Intercom.Visibility visibility) {
        this.launcherVisibility = visibility;
        this.refreshOverlayStates(visibility);
    }

    private void refreshOverlayStates(Intercom.Visibility visibility) {
        if (visibility == Intercom.Visibility.GONE) {
            this.conditionallyRemovePreview(this.lastActive);
        }
        this.conditionallyAddPreview(this.conversations);
    }

    private void displayFirstMessageVisuals(Activity activity) {
        LayoutInflater inflater = activity.getLayoutInflater();
        View view = inflater.inflate(R.layout.intercom_onboarding_layout, null);
        Toast toast = new Toast((Context)activity);
        toast.setGravity(17, 0, 0);
        toast.setDuration(1);
        toast.setView(view);
        toast.show();
    }

    public void reset() {
        this.conversations.clear();
        this.notificationManager.reset();
        this.conditionallyRemovePreview(this.lastActive);
    }

    @Subscribe
    public void unreadConversationsReceived(UnreadConversationsEvent event) {
        IntercomLogger.internal("chathead", "received unread count update with: " + event.getResponse().getConversations() + " conversations and total unread count of " + event.getResponse().getUnreadConversationIds().size());
        this.conversations.clear();
        this.conversations.addAll(event.getResponse().getConversations());
        this.removeDismissedConversations(this.conversations, this.dismissedPartIds);
        this.removeBadgeConversations(this.conversations);
        this.conditionallyAddPreview(this.conversations);
        for (Conversation conversation : event.getResponse().getConversations()) {
            Part lastPart = conversation.getLastPart();
            if (Part.DeliveryOption.SUMMARY == lastPart.getDeliveryOption()) {
                if (lastPart.isInitialMessage()) {
                    this.metricsStore.track(this.metricFactory.receivedMessageFromSnippetWhenClosed(lastPart.hasAttachments(), lastPart.isLinkCard(), conversation.getId(), lastPart.getId(), lastPart.getMessageStyle()));
                    continue;
                }
                this.metricsStore.track(this.metricFactory.receivedReplyFromSnippetWhenClosed(lastPart.hasAttachments(), lastPart.isLinkCard(), conversation.getId(), lastPart.getId()));
                continue;
            }
            this.metricsStore.track(this.metricFactory.receivedMessageFromFullWhenClosed(lastPart.hasAttachments(), lastPart.isLinkCard(), conversation.getId(), lastPart.getId(), lastPart.getMessageStyle()));
        }
    }

    @Subscribe
    public void configUpdated(ConfigUpdateEvent event) {
        if (this.shouldDisplayLauncher(this.lastActive, this.conversations)) {
            try {
                final ViewGroup root = this.getRootView();
                ViewUtils.waitForViewAttachment((View)root, new Runnable(){

                    @Override
                    public void run() {
                        PreviewManager.this.defaultLauncherManager.displayLauncherOnAttachedRoot(root);
                    }
                });
            }
            catch (Exception e) {
                IntercomLogger.internal("Couldn't display launcher: " + e.getMessage());
            }
        } else {
            this.defaultLauncherManager.updateLauncherBackground();
        }
    }

    @Subscribe
    public void conversationMarkedAsRead(ReadEvent event) {
        for (Conversation conversation : this.conversations) {
            if (!conversation.getId().equals(event.getConversationId())) continue;
            this.conversations.remove(conversation);
            break;
        }
        if (this.conversations.size() == 1 && this.store.state().unreadConversationIds().size() > this.conversations.size()) {
            this.api.getUnreadConversations();
        }
    }

    @Subscribe
    public void newComment(NewCommentEvent event) {
        this.realtimeUpdate();
    }

    @Subscribe
    public void newConversation(CreateConversationEvent event) {
        this.realtimeUpdate();
    }

    @Subscribe
    public void firstMessage(FirstMessageEvent event) {
        IntercomLogger.i(this.application.getString(R.string.intercom_activated_key_message));
        try {
            this.displayFirstMessageVisuals(this.lastActive);
        }
        catch (Exception e) {
            IntercomLogger.internal("Couldn't first message: " + e.getMessage());
        }
    }

    private void realtimeUpdate() {
        if (IntercomUtils.isHostActivity(this.lastActive)) {
            this.api.getUnreadConversations();
        }
    }

    @Override
    public void onActivityResumed(Activity activity) {
        this.lastActive = activity;
        this.conditionallyAddPreview(this.conversations);
    }

    @Override
    public void onActivityPaused(Activity activity) {
        this.handler.removeCallbacksAndMessages(null);
        this.conditionallyRemovePreview(activity);
        this.lastActive = null;
    }

    public void conditionallyAddPreview(final List<Conversation> conversations) {
        long expectedActivityLoadTime = (int)(500.0f * this.transitionScale);
        if (this.shouldDisplayPreview(this.lastActive, conversations)) {
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (PreviewManager.this.shouldDisplayPreview(PreviewManager.this.lastActive, conversations)) {
                        PreviewManager.this.displayPreview((Context)PreviewManager.this.lastActive, conversations);
                    }
                }
            }, expectedActivityLoadTime);
        } else if (this.shouldDisplayLauncher(this.lastActive, conversations)) {
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (PreviewManager.this.shouldDisplayLauncher(PreviewManager.this.lastActive, conversations)) {
                        try {
                            final ViewGroup root = PreviewManager.this.getRootView();
                            ViewUtils.waitForViewAttachment((View)root, new Runnable(){

                                @Override
                                public void run() {
                                    PreviewManager.this.defaultLauncherManager.displayLauncherOnAttachedRoot(root);
                                }
                            });
                        }
                        catch (Exception e) {
                            IntercomLogger.internal("Couldn't display launcher: " + e.getMessage());
                        }
                    }
                }
            }, expectedActivityLoadTime);
        }
    }

    void conditionallyRemovePreview(Activity activity) {
        if (activity != null) {
            final View root = activity.findViewById(R.id.preview_root);
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (root != null) {
                        PreviewManager.this.defaultLauncherManager.reset();
                        PreviewManager.this.notificationManager.reset();
                        if (root.getParent() != null) {
                            ((ViewGroup)root.getParent()).removeView(root);
                        }
                    }
                }
            });
        }
    }

    void displayPreview(@NonNull Context context, final List<Conversation> conversations) {
        AvatarUtils.preloadAvatar(conversations.get(0).getLastAdmin().getAvatar(), context, new Runnable(){

            @Override
            public void run() {
                if (PreviewManager.this.shouldDisplayPreview(PreviewManager.this.lastActive, conversations)) {
                    PreviewManager.this.displayPreviewWithPreloadedAvatar(conversations);
                }
            }
        });
    }

    void displayPreviewWithPreloadedAvatar(List<Conversation> conversations) {
        ViewGroup rootView;
        try {
            rootView = this.getRootView();
        }
        catch (Exception ignored) {
            return;
        }
        Conversation conversation = conversations.get(0);
        String messageStyle = conversation.getLastPart().getMessageStyle();
        Part.DeliveryOption deliveryOption = conversation.getLastPart().getDeliveryOption();
        if (conversations.size() > 1 || this.notificationManager.isDisplaying() || deliveryOption == Part.DeliveryOption.SUMMARY || deliveryOption == Part.DeliveryOption.FULL && "chat".equals(messageStyle)) {
            this.soundPlayer.playAdminReplySound();
            if (this.defaultLauncherManager.isDisplaying()) {
                this.notificationManager.displayNotificationsWithLauncherAnimation(rootView, conversations, this.defaultLauncherManager.getLauncher());
            } else {
                this.notificationManager.displayNotifications(rootView, conversations);
            }
        } else if (deliveryOption == Part.DeliveryOption.FULL) {
            if ("post".equals(messageStyle)) {
                this.soundPlayer.playAdminReplySound();
                this.openPost(conversation, false);
            } else if ("note".equals(messageStyle)) {
                this.soundPlayer.playAdminReplySound();
                this.openNote(conversation, false);
            }
        }
    }

    @Override
    public ViewGroup getRootView() throws Exception {
        if (this.lastActive == null) {
            throw new NullPointerException();
        }
        ViewGroup root = (ViewGroup)this.lastActive.findViewById(R.id.preview_root);
        if (root == null) {
            root = (ViewGroup)this.lastActive.getLayoutInflater().inflate(R.layout.intercom_preview_container, null, false);
            this.lastActive.addContentView((View)root, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 80));
        }
        return root;
    }

    @Override
    public void markAsDismissed(Conversation conversation) {
        this.api.markConversationAsDismissed(conversation.getId());
        this.dismissedPartIds.add(conversation.getLastPart().getId());
        this.removeDismissedConversations(this.conversations, this.dismissedPartIds);
        if (this.shouldDisplayLauncher(this.lastActive, this.conversations)) {
            try {
                final ViewGroup root = this.getRootView();
                ViewUtils.waitForViewAttachment((View)root, new Runnable(){

                    @Override
                    public void run() {
                        PreviewManager.this.defaultLauncherManager.displayLauncherOnAttachedRoot(root);
                    }
                });
            }
            catch (Exception e) {
                IntercomLogger.internal("Couldn't display launcher: " + e.getMessage());
            }
        }
    }

    @Override
    public void openNotification(Conversation conversation) {
        Part lastPart = conversation.getLastAdminPart();
        String messageStyle = lastPart.getMessageStyle();
        if ("post".equals(messageStyle)) {
            this.openPost(conversation, true);
        } else if ("note".equals(messageStyle)) {
            this.openNote(conversation, true);
        } else {
            this.openMessenger(conversation);
            if ("chat".equals(messageStyle) && Part.DeliveryOption.FULL == lastPart.getDeliveryOption()) {
                this.metricsStore.track(this.metricFactory.openedConversationFromFull(conversation.getId(), lastPart.getId()));
            } else {
                this.metricsStore.track(this.metricFactory.openedConversationFromSnippet(conversation.getId(), lastPart.getId()));
            }
        }
    }

    private void openMessenger(Conversation conversation) {
        this.application.startActivity(IntercomMessengerActivity.openConversation((Context)this.application, conversation.getId(), conversation.getLastParticipatingAdmin()));
    }

    private void openPost(Conversation conversation, boolean openedFromSnippet) {
        Part lastPart = conversation.getLastPart();
        if (openedFromSnippet) {
            this.metricsStore.track(this.metricFactory.viewedInAppFromSnippet(conversation.getId(), lastPart.getId()));
        } else {
            this.metricsStore.track(this.metricFactory.viewedInAppFromFull(conversation.getId(), lastPart.getId()));
        }
        this.application.startActivity(IntercomPostActivity.buildPostIntent((Context)this.application, conversation.getLastPart(), conversation.getId(), conversation.getLastParticipatingAdmin(), true));
    }

    private void openNote(Conversation conversation, boolean openedFromSnippet) {
        Part lastPart = conversation.getLastPart();
        if (openedFromSnippet) {
            this.metricsStore.track(this.metricFactory.viewedInAppFromSnippet(conversation.getId(), lastPart.getId()));
        } else {
            this.metricsStore.track(this.metricFactory.viewedInAppFromFull(conversation.getId(), lastPart.getId()));
        }
        try {
            this.application.startActivity(IntercomNoteActivity.buildNoteIntent((Context)this.application, lastPart, conversation.getId(), conversation.getLastParticipatingAdmin()));
        }
        catch (IllegalArgumentException e) {
            IntercomLogger.internal("preview", "Error loading the note " + e.getMessage());
        }
    }

    boolean shouldDisplayPreview(@Nullable Activity activity, List<Conversation> conversations) {
        boolean result = this.previewVisibility == Intercom.Visibility.VISIBLE && conversations != null && !conversations.isEmpty() && IntercomUtils.isHostActivity(activity);
        IntercomLogger.internal("preview", "should display preview: " + result);
        return result;
    }

    boolean shouldDisplayLauncher(@Nullable Activity activity, List<Conversation> conversations) {
        if (this.previewVisibility == Intercom.Visibility.VISIBLE) {
            for (Conversation c : conversations) {
                if (Part.DeliveryOption.BADGE == c.getLastPart().getDeliveryOption()) continue;
                return false;
            }
        }
        return this.launcherVisibility == Intercom.Visibility.VISIBLE && this.userIdentity.identityExists() && this.appConfigProvider.getAppConfig().isReceivedFromServer() && IntercomUtils.isHostActivity(activity);
    }

    private void removeDismissedConversations(List<Conversation> conversations, Set<String> dismissedPartIds) {
        for (int i = conversations.size() - 1; i >= 0; --i) {
            if (!dismissedPartIds.contains(conversations.get(i).getLastPart().getId())) continue;
            conversations.remove(i);
        }
    }

    private void removeBadgeConversations(List<Conversation> conversations) {
        for (int i = conversations.size() - 1; i >= 0; --i) {
            if (conversations.get(i).getLastPart().getDeliveryOption() != Part.DeliveryOption.BADGE) continue;
            conversations.remove(i);
        }
    }

    @VisibleForTesting
    Intercom.Visibility getPreviewVisibility() {
        return this.previewVisibility;
    }

    @VisibleForTesting
    Intercom.Visibility getLauncherVisibility() {
        return this.launcherVisibility;
    }
}

