/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.preview;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.preview.ChatOverlay;
import io.intercom.android.sdk.preview.PreviewCallbacks;
import io.intercom.android.sdk.utilities.AvatarUtils;

class ChatSnippet
extends ChatOverlay {
    private TextView contentBody;

    public ChatSnippet(Context localisedContext, Conversation conversation, int position, int screenHeight, PreviewCallbacks previewCallbacks) {
        super(localisedContext, conversation, position, screenHeight, previewCallbacks);
    }

    @Override
    protected ViewGroup inflateChatRootView(ViewGroup parent, LayoutInflater inflater) {
        ViewGroup root = (ViewGroup)inflater.inflate(R.layout.intercom_preview_chat_snippet_overlay, parent, false);
        this.contentBody = (TextView)inflater.inflate(R.layout.intercom_preview_chat_snippet_body, root, false);
        ((ViewGroup)root.findViewById(R.id.chathead_text_container)).addView((View)this.contentBody);
        return root;
    }

    @Override
    protected void updateContentContainer(Part part) {
        this.setBodyText(part);
    }

    @Override
    protected View getContentContainer() {
        return this.overlayRoot.findViewById(R.id.chathead_text_body);
    }

    @Override
    public void update(Conversation conversation, Runnable updateEndAction) {
        this.conversation = conversation;
        View text = this.overlayRoot.findViewById(R.id.chathead_text_body);
        View textContainer = this.overlayRoot.findViewById(R.id.chathead_text_container);
        textContainer.setPivotX(0.0f);
        this.performReplyPulse(textContainer, text, updateEndAction);
    }

    @Override
    protected void updateViewDataDuringReplyPulse() {
        ImageView avatarView = (ImageView)this.overlayRoot.findViewById(R.id.chathead_avatar);
        AvatarUtils.loadAvatarIntoView(this.conversation.getLastAdmin().getAvatar(), avatarView);
        TextView headerTextView = (TextView)this.overlayRoot.findViewById(R.id.chathead_text_header);
        headerTextView.setText(this.getHeaderText());
        Part lastPart = this.conversation.getLastPart();
        this.setBodyText(lastPart);
    }

    private void setBodyText(Part part) {
        if (part.getSummary().isEmpty()) {
            this.contentBody.setText((CharSequence)this.localisedContext.getString(R.string.intercom_image_attached));
        } else {
            this.contentBody.setText((CharSequence)part.getSummary());
        }
    }
}

