/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import io.intercom.android.sdk.nexus.NexusConfig;
import java.util.concurrent.TimeUnit;

public class Config {
    public static final String DEFAULT_COLOR_KEY = "default";
    public static final int DEFAULT_CACHE_MAX_AGE_MS = 300000;
    public static final int DEFAULT_RATE_LIMIT_COUNT_MS = 100000;
    public static final int DEFAULT_RATE_LIMIT_PERIOD_MS = 60000;
    public static final int DEFAULT_SESSION_TIMEOUT_MS = 20000;
    private final String name;
    private final String baseColor;
    private final boolean metricsEnabled;
    private final boolean audioEnabled;
    private final boolean isFirstRequest;
    private final boolean inboundMessages;
    private final boolean showPoweredBy;
    private final NexusConfig realTimeConfig;
    private final Integer rateLimitCount;
    private final Long userUpdateCacheMaxAgeMs;
    private final Long rateLimitPeriodMs;
    private final Long newSessionThresholdMs;
    private final String messengerBackground;
    private final String welcomeMessage;
    private final String locale;

    public Config() {
        this(new Builder());
    }

    Config(Builder builder) {
        this.name = builder.name == null ? "" : builder.name;
        this.isFirstRequest = builder.is_first_request;
        this.inboundMessages = builder.inbound_messages;
        this.showPoweredBy = builder.show_powered_by;
        this.baseColor = builder.base_color == null ? DEFAULT_COLOR_KEY : builder.base_color;
        this.realTimeConfig = builder.real_time_config == null ? new NexusConfig() : builder.real_time_config.build();
        this.rateLimitPeriodMs = builder.local_rate_limit_period == null ? 60000L : TimeUnit.SECONDS.toMillis(builder.local_rate_limit_period);
        this.rateLimitCount = builder.local_rate_limit == null ? 100000 : builder.local_rate_limit;
        this.newSessionThresholdMs = builder.new_session_threshold == null ? 20000L : TimeUnit.SECONDS.toMillis(builder.new_session_threshold);
        this.userUpdateCacheMaxAgeMs = builder.user_update_dup_cache_max_age == null ? 300000L : TimeUnit.SECONDS.toMillis(builder.user_update_dup_cache_max_age);
        this.welcomeMessage = builder.welcome_message_plain_text == null ? "" : builder.welcome_message_plain_text;
        this.messengerBackground = builder.messenger_background == null ? "" : builder.messenger_background;
        this.locale = builder.locale == null ? "" : builder.locale;
        this.audioEnabled = builder.audio_enabled == null ? true : builder.audio_enabled;
        this.metricsEnabled = builder.metrics_enabled == null ? true : builder.metrics_enabled;
    }

    public String getName() {
        return this.name;
    }

    public String getBaseColor() {
        return this.baseColor;
    }

    public boolean isFirstRequest() {
        return this.isFirstRequest;
    }

    public boolean isInboundMessages() {
        return this.inboundMessages;
    }

    public boolean isShowPoweredBy() {
        return this.showPoweredBy;
    }

    public long getUserUpdateCacheMaxAge() {
        return this.userUpdateCacheMaxAgeMs;
    }

    public NexusConfig getRealTimeConfig() {
        return this.realTimeConfig;
    }

    public boolean isAudioEnabled() {
        return this.audioEnabled;
    }

    public long getRateLimitPeriod() {
        return this.rateLimitPeriodMs;
    }

    public int getRateLimitCount() {
        return this.rateLimitCount;
    }

    public long getNewSessionThreshold() {
        return this.newSessionThresholdMs;
    }

    public String getWelcomeMessage() {
        return this.welcomeMessage;
    }

    public String getMessengerBackground() {
        return this.messengerBackground;
    }

    public String getLocale() {
        return this.locale;
    }

    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Config config = (Config)o;
        if (this.isFirstRequest != config.isFirstRequest) {
            return false;
        }
        if (this.inboundMessages != config.inboundMessages) {
            return false;
        }
        if (this.showPoweredBy != config.showPoweredBy) {
            return false;
        }
        if (this.metricsEnabled != config.metricsEnabled) {
            return false;
        }
        if (this.audioEnabled != config.audioEnabled) {
            return false;
        }
        if (!this.userUpdateCacheMaxAgeMs.equals(config.userUpdateCacheMaxAgeMs)) {
            return false;
        }
        if (!this.rateLimitPeriodMs.equals(config.rateLimitPeriodMs)) {
            return false;
        }
        if (!this.rateLimitCount.equals(config.rateLimitCount)) {
            return false;
        }
        if (!this.newSessionThresholdMs.equals(config.newSessionThresholdMs)) {
            return false;
        }
        if (!this.name.equals(config.name)) {
            return false;
        }
        if (!this.baseColor.equals(config.baseColor)) {
            return false;
        }
        if (!this.realTimeConfig.equals((Object)config.realTimeConfig)) {
            return false;
        }
        if (!this.messengerBackground.equals(config.messengerBackground)) {
            return false;
        }
        if (!this.welcomeMessage.equals(config.welcomeMessage)) {
            return false;
        }
        return this.locale.equals(config.locale);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.baseColor.hashCode();
        result = 31 * result + (this.isFirstRequest ? 1 : 0);
        result = 31 * result + (this.inboundMessages ? 1 : 0);
        result = 31 * result + (this.showPoweredBy ? 1 : 0);
        result = 31 * result + (this.metricsEnabled ? 1 : 0);
        result = 31 * result + this.realTimeConfig.hashCode();
        result = 31 * result + (this.audioEnabled ? 1 : 0);
        result = 31 * result + this.userUpdateCacheMaxAgeMs.hashCode();
        result = 31 * result + this.rateLimitCount.hashCode();
        result = 31 * result + this.rateLimitPeriodMs.hashCode();
        result = 31 * result + this.newSessionThresholdMs.hashCode();
        result = 31 * result + this.messengerBackground.hashCode();
        result = 31 * result + this.welcomeMessage.hashCode();
        result = 31 * result + this.locale.hashCode();
        return result;
    }

    public static final class Builder {
        String name;
        String base_color;
        Boolean metrics_enabled;
        Boolean audio_enabled;
        boolean is_first_request;
        boolean inbound_messages;
        boolean show_powered_by;
        NexusConfig.Builder real_time_config;
        Integer local_rate_limit;
        Long user_update_dup_cache_max_age;
        Long local_rate_limit_period;
        Long new_session_threshold;
        String messenger_background;
        String welcome_message_plain_text;
        String locale;

        public Config build() {
            return new Config(this);
        }
    }
}

