/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.metrics;

import android.support.annotation.NonNull;
import android.text.Editable;
import android.text.TextUtils;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.utilities.SimpleTextWatcher;

public class MetricsComposerTextWatcher
extends SimpleTextWatcher {
    private final MetricsStore metricsStore;
    private final MetricFactory metricFactory;
    private String conversationId;
    private boolean hasTrackedEvent;

    public MetricsComposerTextWatcher(@NonNull MetricsStore metricsStore, @NonNull MetricFactory metricFactory) {
        this.metricsStore = metricsStore;
        this.metricFactory = metricFactory;
    }

    @Override
    public void afterTextChanged(Editable s) {
        if (!this.hasTrackedEvent) {
            if (TextUtils.isEmpty((CharSequence)this.conversationId)) {
                this.metricsStore.track(this.metricFactory.typeInNewConversation());
            } else {
                this.metricsStore.track(this.metricFactory.typeInConversation(this.conversationId));
            }
            this.hasTrackedEvent = true;
        }
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public void reset() {
        this.hasTrackedEvent = false;
    }
}

