/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.push;

import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.push.IntercomNotificationFactory;
import io.intercom.android.sdk.push.PushNotification;
import java.util.ArrayList;
import java.util.List;

public class IntercomNotificationManager {
    private static final int NOTIFICATION_ID = 9999997;
    @VisibleForTesting
    final List<PushNotification> notifications = new ArrayList<PushNotification>();
    private final IntercomNotificationFactory notificationFactory = new IntercomNotificationFactory();
    private final NotificationManager notificationManager;

    public IntercomNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public void killNotifications() {
        if (!this.notifications.isEmpty()) {
            IntercomLogger.i("Removing Intercom FCM messages.");
        }
        this.notificationManager.cancel(9999997);
        this.notifications.clear();
    }

    void createPushOnlyNotification(PushNotification pushNotification, Context context) {
        Notification notification = this.notificationFactory.createPushOnlyNotification(pushNotification, context);
        String pushOnlyConversationId = pushNotification.getPushOnlyConversationId();
        this.notificationManager.notify(pushOnlyConversationId, pushOnlyConversationId.hashCode(), notification);
    }

    void createNotification(PushNotification pushNotification, Context context) {
        this.notifications.add(pushNotification);
        Notification notification = this.notifications.size() == 1 ? this.notificationFactory.createSingleNotification(this.notifications.get(0), context) : this.notificationFactory.createGroupedNotification(this.notifications, context);
        this.notificationManager.notify(9999997, notification);
    }
}

