/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.push;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.push.PushReceiverDelegate;

public class IntercomPushBroadcastReceiver
extends BroadcastReceiver {
    public static final String INTERCOM_PUSH_OPENED = "io.intercom.android.sdk.INTERCOM_PUSH_OPENED";
    public static final String INTERCOM_PUSH_DISMISSED = "io.intercom.android.sdk.INTERCOM_PUSH_DISMISSED";
    private final PushReceiverDelegate pushReceiverDelegate = new PushReceiverDelegate();

    public void onReceive(Context context, Intent intent) {
        Injector.init((Application)context.getApplicationContext());
        UserIdentity userIdentity = Injector.get().getUserIdentity();
        MetricFactory metricFactory = new MetricFactory(userIdentity);
        MetricsStore metricStore = Injector.get().getMetricsStore();
        switch (intent.getAction()) {
            case "io.intercom.android.sdk.INTERCOM_PUSH_DISMISSED": {
                this.dismissIntent(intent, userIdentity, metricStore, metricFactory);
                break;
            }
            default: {
                this.handleIntent(context, intent, userIdentity, metricStore, metricFactory);
            }
        }
    }

    private void handleIntent(Context context, Intent intent, UserIdentity userIdentity, MetricsStore metricsStore, MetricFactory metricFactory) {
        this.pushReceiverDelegate.handleIntent(context, intent, Injector.get().getApi(), userIdentity, metricsStore, metricFactory);
    }

    private void dismissIntent(Intent intent, UserIdentity userIdentity, MetricsStore metricsStore, MetricFactory metricFactory) {
        this.pushReceiverDelegate.dismissIntent(intent, userIdentity, metricsStore, metricFactory);
    }
}

