/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.blockInterfaces.AttachmentListBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.LocalAttachmentBlock;
import io.intercom.android.sdk.blocks.models.BlockAttachment;
import io.intercom.android.sdk.blocks.views.AttachmentView;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.views.ProgressLinearLayout;
import io.intercom.android.sdk.views.UploadProgressBar;
import java.util.List;

class Attachment
implements AttachmentListBlock,
LocalAttachmentBlock {
    private static final int ATTACHMENT_LINE_SPACING_DP = 12;
    private static final int LOCAL_ICON_SIZE_DP = 20;
    private static final int DIVIDER_MARGIN_DP = 6;
    private static final int DIVIDER_WIDTH_DP = 1;
    private final StyleType style;
    private final Context context;
    private final AppConfig.Provider appConfigProvider;

    public Attachment(Context context, StyleType style, AppConfig.Provider appConfigProvider) {
        this.style = style;
        this.context = context;
        this.appConfigProvider = appConfigProvider;
    }

    public View addAttachmentList(List<BlockAttachment> attachments, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        int baseColour = this.appConfigProvider.getAppConfig().getBaseColor();
        LinearLayout layout2 = this.getAttachmentListView();
        int count = attachments.size();
        for (int i = 0; i < count; ++i) {
            AttachmentView attachmentLayout = new AttachmentView(this.context, this.style, baseColour, attachments.get(i));
            if (i < count - 1) {
                attachmentLayout.setPadding(attachmentLayout.getPaddingLeft(), attachmentLayout.getPaddingTop(), attachmentLayout.getPaddingRight(), ScreenUtils.dpToPx((float)12.0f, (Context)this.context));
            }
            layout2.addView((View)attachmentLayout);
        }
        BlockUtils.setLayoutMarginsAndGravity((View)layout2, 3, isLastObject);
        return layout2;
    }

    private LinearLayout getAttachmentListView() {
        LinearLayout layout2 = new LinearLayout(this.context);
        layout2.setOrientation(1);
        layout2.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.intercom_full_transparent_full_black));
        BlockUtils.createLayoutParams((View)layout2, -2, -2);
        BlockUtils.setDefaultMarginBottom((View)layout2);
        return layout2;
    }

    public View addAttachment(BlockAttachment blockAttachment, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        ProgressLinearLayout rootView = this.getLocalAttachmentView();
        FrameLayout frame = this.getIconHolder();
        ImageView attachmentIcon = this.getAttachmentIcon();
        UploadProgressBar uploadProgressBar = this.getUploadProgressBar();
        View divider = this.getDivider();
        TextView textView = this.getTextView(blockAttachment.getName());
        frame.addView((View)uploadProgressBar);
        frame.addView((View)attachmentIcon);
        rootView.setUploadProgressBar(uploadProgressBar);
        rootView.setAttachmentIcon(attachmentIcon);
        rootView.addView((View)frame);
        rootView.addView(divider);
        rootView.addView((View)textView);
        BlockUtils.setLayoutMarginsAndGravity((View)rootView, 3, isLastObject);
        return rootView;
    }

    private ProgressLinearLayout getLocalAttachmentView() {
        ProgressLinearLayout root = new ProgressLinearLayout(this.context);
        BlockUtils.createLayoutParams((View)root, -2, -2);
        BlockUtils.setDefaultMarginBottom((View)root);
        root.setOrientation(0);
        return root;
    }

    private FrameLayout getIconHolder() {
        int localIconSizeDp = ScreenUtils.dpToPx((float)20.0f, (Context)this.context);
        FrameLayout frame = new FrameLayout(this.context);
        BlockUtils.createLayoutParams((View)frame, localIconSizeDp, localIconSizeDp);
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)frame.getLayoutParams();
        params.gravity = 19;
        return frame;
    }

    private UploadProgressBar getUploadProgressBar() {
        UploadProgressBar uploadProgressBar = new UploadProgressBar(this.context);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        uploadProgressBar.setLayoutParams((ViewGroup.LayoutParams)params);
        return uploadProgressBar;
    }

    private ImageView getAttachmentIcon() {
        ImageView attachmentIcon = new ImageView(this.context);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        attachmentIcon.setLayoutParams((ViewGroup.LayoutParams)params);
        attachmentIcon.setVisibility(8);
        attachmentIcon.setImageResource(R.drawable.intercom_icn_attachment);
        return attachmentIcon;
    }

    private View getDivider() {
        int dividerMarginDp = ScreenUtils.dpToPx((float)6.0f, (Context)this.context);
        int dividerWidthDp = ScreenUtils.dpToPx((float)1.0f, (Context)this.context);
        View view = new View(this.context);
        view.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.intercom_white));
        BlockUtils.createLayoutParams(view, dividerWidthDp, -1);
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)view.getLayoutParams();
        params.leftMargin = dividerMarginDp;
        params.rightMargin = dividerMarginDp;
        return view;
    }

    private TextView getTextView(String name) {
        TextView textView = new TextView(this.context);
        BlockUtils.createLayoutParams((View)textView, -2, -2);
        BlockUtils.setSmallLineSpacing(textView);
        textView.setGravity(19);
        textView.setEllipsize(TextUtils.TruncateAt.END);
        textView.setTextSize(15.0f);
        textView.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.intercom_white));
        textView.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.intercom_full_transparent_full_black));
        textView.setText((CharSequence)name);
        return textView;
    }
}

