/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.profile;

import android.content.Context;
import android.os.Build;
import android.support.design.widget.AppBarLayout;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.profile.ProfileToolbarBehavior;

class TeammateProfileToolbarBehavior
extends ProfileToolbarBehavior {
    private static final float CHANGE_IN_AVATAR_SCALE = 0.5f;
    private static final float CHANGE_IN_TITLE_SCALE = 0.1f;
    private final float translate8dp;
    private final float translate16dp;
    private final float translate18dp;
    private final float maxAlpha;
    private final ViewGroup rootLayout;
    private ImageView avatar;
    private TextView title;
    private TextView subtitle;
    private TextView role;
    private TextView location;
    private TextView bio;
    private LinearLayout socialLayout;
    private ImageView backgroundView;

    public TeammateProfileToolbarBehavior(ViewGroup rootLayout) {
        super(rootLayout.getContext());
        this.rootLayout = rootLayout;
        Context context = rootLayout.getContext();
        this.translate8dp = ScreenUtils.dpToPx((float)8.0f, (Context)context);
        this.translate16dp = ScreenUtils.dpToPx((float)16.0f, (Context)context);
        this.translate18dp = ScreenUtils.dpToPx((float)18.0f, (Context)context);
        TypedValue outValue = new TypedValue();
        context.getResources().getValue(R.dimen.intercom_toolbar_image_background_alpha, outValue, true);
        this.maxAlpha = outValue.getFloat();
    }

    private void updateSocialButtons(ViewGroup child, View dependency) {
        if (this.socialLayout == null) {
            this.socialLayout = (LinearLayout)child.findViewById(R.id.social_button_layout);
        }
        this.translateY((View)this.socialLayout, dependency, this.translate16dp);
        this.setAlphaAsPercentageOfScroll((View)this.socialLayout, dependency, 1.0f, false);
    }

    private void updateRole(ViewGroup child, View dependency) {
        if (this.role == null) {
            this.role = (TextView)child.findViewById(R.id.intercom_collapsing_role);
        }
        this.translateY((View)this.role, dependency, this.translate16dp);
        this.setAlphaAsPercentageOfScroll((View)this.role, dependency, 1.0f, false);
    }

    private void updateLocation(ViewGroup child, View dependency) {
        if (this.location == null) {
            this.location = (TextView)child.findViewById(R.id.intercom_collapsing_location);
        }
        this.translateY((View)this.location, dependency, this.translate16dp);
        this.setAlphaAsPercentageOfScroll((View)this.location, dependency, 1.0f, false);
    }

    private void updateBio(ViewGroup child, View dependency) {
        if (this.bio == null) {
            this.bio = (TextView)child.findViewById(R.id.intercom_collapsing_bio);
        }
        this.translateY((View)this.bio, dependency, this.translate16dp);
        this.setAlphaAsPercentageOfScroll((View)this.bio, dependency, 0.7f, false);
    }

    private void updateTitle(ViewGroup child, float scrollPercentage) {
        float translationYSubtitle;
        float newTransYSubtitle;
        float translationY;
        float newTransY;
        float translationX;
        float newTransX;
        if (this.title == null) {
            this.title = (TextView)child.findViewById(R.id.intercom_collapsing_title);
        }
        if (this.subtitle == null) {
            this.subtitle = (TextView)child.findViewById(R.id.intercom_collapsing_subtitle);
        }
        if ((newTransX = (float)((int)Math.max(translationX = this.translate16dp / 100.0f * scrollPercentage, 0.0f))) > 0.0f) {
            this.title.setTranslationX(newTransX);
            this.subtitle.setTranslationX(newTransX);
        }
        if ((newTransY = (float)((int)Math.max(0.0f, translationY = this.translate16dp / 100.0f * scrollPercentage))) > 0.0f) {
            this.title.setTranslationY(newTransY);
        }
        if ((newTransYSubtitle = (float)((int)Math.max(0.0f, translationYSubtitle = this.translate18dp / 100.0f * scrollPercentage))) > 0.0f) {
            this.subtitle.setTranslationY(newTransYSubtitle);
        }
        float scale = 1.0f + 0.001f * scrollPercentage;
        this.title.setPivotX(0.0f);
        this.title.setPivotY(0.0f);
        this.title.setScaleX(scale);
        this.title.setScaleY(scale);
    }

    private void updateAvatar(ViewGroup child, float scrollPercentage) {
        if (this.avatar == null) {
            this.avatar = (ImageView)child.findViewById(R.id.intercom_collapsing_teammate_avatar);
        }
        float translationX = this.translate8dp / 100.0f * scrollPercentage;
        this.avatar.setTranslationX((float)((int)Math.max(translationX, 0.0f)));
        float translationY = this.translate16dp / 100.0f * scrollPercentage;
        this.avatar.setTranslationY((float)((int)Math.max(0.0f, translationY)));
        float scale = 1.0f + 0.005f * scrollPercentage;
        this.avatar.setScaleX(scale);
        this.avatar.setScaleY(scale);
    }

    private void updateBackgroundImage(ViewGroup child, View dependency) {
        if (this.backgroundView == null) {
            this.backgroundView = (ImageView)child.findViewById(R.id.collapsing_background_image);
        }
        this.setAlphaAsPercentageOfScroll((View)this.backgroundView, dependency, this.maxAlpha, false);
    }

    public void onOffsetChanged(AppBarLayout appBarLayout, int verticalOffset) {
        boolean isInLayoutPass = false;
        if (Build.VERSION.SDK_INT >= 18) {
            isInLayoutPass = this.rootLayout.isInLayout();
        }
        if ((float)appBarLayout.getHeight() <= this.toolbarHeight || isInLayoutPass) {
            return;
        }
        float scrollPercentage = this.getScrollPercentage((View)appBarLayout);
        this.rootLayout.getLayoutParams().height = appBarLayout.getBottom();
        this.updateAvatar(this.rootLayout, scrollPercentage);
        this.updateTitle(this.rootLayout, scrollPercentage);
        this.updateRole(this.rootLayout, (View)appBarLayout);
        this.updateLocation(this.rootLayout, (View)appBarLayout);
        this.updateBio(this.rootLayout, (View)appBarLayout);
        this.updateSocialButtons(this.rootLayout, (View)appBarLayout);
        this.updateBackgroundImage(this.rootLayout, (View)appBarLayout);
        this.rootLayout.requestLayout();
    }

    private void translateY(View child, View dependency, float totalYTranslation) {
        float translation = totalYTranslation / 100.0f * this.getScrollPercentage(dependency);
        child.setTranslationY((float)((int)Math.max(0.0f, translation)));
    }
}

