/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.conversation.events.AdminIsTypingEvent;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.models.events.realtime.CreateConversationEvent;
import io.intercom.android.sdk.models.events.realtime.NewCommentEvent;
import io.intercom.android.sdk.models.events.realtime.UserContentSeenByAdminEvent;
import io.intercom.android.sdk.nexus.NexusClient;
import io.intercom.android.sdk.nexus.NexusConfig;
import io.intercom.android.sdk.nexus.NexusEvent;
import io.intercom.android.sdk.nexus.NexusListener;
import io.intercom.com.squareup.otto.Bus;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class NexusWrapper
extends NexusClient
implements NexusListener {
    private final Bus bus;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture actionFuture;
    private long debouncePeriodMs;

    public NexusWrapper(Bus bus) {
        this(bus, 1000);
    }

    NexusWrapper(Bus bus, int debouncePeriodMs) {
        this.bus = bus;
        this.debouncePeriodMs = debouncePeriodMs;
    }

    public void connect(final NexusConfig config, final boolean shouldSendPresence) {
        if (!config.getEndpoints().isEmpty()) {
            this.removeCallbacks();
            this.actionFuture = this.executor.schedule(new Runnable(){

                @Override
                public void run() {
                    NexusWrapper.this.connectNow(config, shouldSendPresence);
                }
            }, this.debouncePeriodMs, TimeUnit.MILLISECONDS);
        }
    }

    @VisibleForTesting
    void connectNow(NexusConfig config, boolean shouldSendPresence) {
        if (!this.isConnected()) {
            super.connect(config, shouldSendPresence);
            this.addEventListener(this);
        }
    }

    public void disconnect() {
        this.removeCallbacks();
        this.actionFuture = this.executor.schedule(new Runnable(){

            @Override
            public void run() {
                NexusWrapper.this.disconnectNow();
            }
        }, this.debouncePeriodMs, TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    void disconnectNow() {
        this.removeEventListener(this);
        super.disconnect();
    }

    private void removeCallbacks() {
        if (this.actionFuture != null) {
            this.actionFuture.cancel(false);
        }
    }

    public void notifyEvent(@NonNull NexusEvent event) {
        switch (event.getEventType()) {
            case AdminIsTyping: {
                IntercomLogger.internal("nexus realtime", "received " + event.getEventType() + " event");
                this.bus.post((Object)new AdminIsTypingEvent(event.getAdminId(), event.getConversationId(), event.getAdminName(), event.getAdminAvatarUrl()));
                break;
            }
            case NewComment: {
                IntercomLogger.internal("nexus realtime", "received " + event.getEventType() + " event");
                this.bus.post((Object)new NewCommentEvent(event.getConversationId()));
                break;
            }
            case CreateConversation: {
                IntercomLogger.internal("nexus realtime", "received " + event.getEventType() + " event");
                this.bus.post((Object)new CreateConversationEvent());
                break;
            }
            case UserContentSeenByAdmin: {
                IntercomLogger.internal("realtime", "received " + event.getEventType() + " event");
                this.bus.post((Object)new UserContentSeenByAdminEvent(event.getConversationId()));
                break;
            }
            default: {
                IntercomLogger.internal("nexus realtime", "unexpected event: " + event.getEventType());
            }
        }
    }

    public void onConnect() {
    }

    public void onConnectFailed() {
    }
}

