/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.content.Context;
import android.graphics.Point;
import android.util.AttributeSet;
import android.widget.ImageView;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.utilities.ImageUtils;

public class ResizableImageView
extends ImageView {
    private int totalViewPadding;
    private int imageWidth;
    private int imageHeight;

    public ResizableImageView(Context context) {
        this(context, null);
    }

    public ResizableImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ResizableImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setDisplayImageDimensions(int imageWidth, int imageHeight) {
        this.imageHeight = imageHeight;
        this.imageWidth = imageWidth;
    }

    public void setTotalViewPadding(int totalViewPadding) {
        this.totalViewPadding = totalViewPadding;
    }

    public Point getImageDimens() {
        double aspectRatio = ImageUtils.getAspectRatio(this.imageWidth, this.imageHeight);
        Point screenDimens = ScreenUtils.getScreenDimensions((Context)this.getContext());
        int maxWidth = screenDimens.x - this.totalViewPadding;
        int minWidth = Math.min(this.imageWidth, maxWidth);
        int minHeight = ImageUtils.getAspectHeight(minWidth, aspectRatio);
        return new Point(minWidth, minHeight);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Point dimens = this.getImageDimens();
        if (this.imageWidth > 0 && this.imageHeight > 0) {
            this.setMeasuredDimension(dimens.x, dimens.y);
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }
}

