/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.support.annotation.NonNull;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.IntercomLogger;
import java.util.Locale;

public class ContextLocaliser {
    private static final String SIMPLIFIED_CHINESE_ISO_15924 = "hans";
    private static final String SIMPLIFIED_CHINESE_COUNTRY = "CN";
    private static final String TRADITIONAL_CHINESE_ISO_15924 = "hant";
    private static final String TRADITIONAL_CHINESE_COUNTRY = "TW";
    private static final String OREO_FORMAL_TAG = "form";
    private static final String FAKE_FORMAL_COUNTRY = "FO";
    private final AppConfig.Provider appConfigProvider;

    public static ContextLocaliser create() {
        return new ContextLocaliser(Injector.get().getAppIdentity());
    }

    ContextLocaliser(AppConfig.Provider appIdentity) {
        this.appConfigProvider = appIdentity;
    }

    public Context createLocalisedContext(Context context) {
        Configuration localisedConfiguration = new Configuration();
        localisedConfiguration.locale = ContextLocaliser.convertToLocale(this.appConfigProvider.getAppConfig().getLocale());
        if (Build.VERSION.SDK_INT >= 17) {
            return context.createConfigurationContext(localisedConfiguration);
        }
        IntercomLogger.d("Localisation outside the Messenger is unsupported on Android 4.0 and 4.1, text may be localised incorrectly");
        return context;
    }

    public static void overrideLocale(Resources resources) {
        Configuration configuration = new Configuration();
        configuration.locale = ContextLocaliser.convertToLocale(Injector.get().getAppIdentity().getAppConfig().getLocale());
        resources.updateConfiguration(configuration, resources.getDisplayMetrics());
    }

    @NonNull
    public static Locale convertToLocale(String locale) {
        if (locale.length() <= 2) {
            return new Locale(locale);
        }
        String language = locale.substring(0, 2);
        String country = locale.substring(3);
        if (SIMPLIFIED_CHINESE_ISO_15924.equalsIgnoreCase(country)) {
            country = SIMPLIFIED_CHINESE_COUNTRY;
        } else if (TRADITIONAL_CHINESE_ISO_15924.equalsIgnoreCase(country)) {
            country = TRADITIONAL_CHINESE_COUNTRY;
        } else if (OREO_FORMAL_TAG.equalsIgnoreCase(country)) {
            country = FAKE_FORMAL_COUNTRY;
        }
        return new Locale(language, country);
    }
}

