/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views.behavior;

import android.content.Context;
import android.support.design.widget.AppBarLayout;
import android.support.v4.view.ViewCompat;
import android.view.View;
import io.intercom.android.sdk.R;

abstract class IntercomToolbarBehavior
implements AppBarLayout.OnOffsetChangedListener {
    float toolbarHeight;

    public IntercomToolbarBehavior(Context context) {
        this.toolbarHeight = context.getResources().getDimension(R.dimen.intercom_toolbar_height);
    }

    public void translateY(View child, View dependency, float totalYTranslation) {
        float translation = totalYTranslation / 100.0f * this.getScrollPercentage(dependency);
        ViewCompat.setTranslationY((View)child, (float)((int)Math.max(0.0f, translation)));
    }

    protected void setAlphaAsPercentageOfScroll(View child, View dependency, float maxAlpha, boolean fadeOut) {
        float scrollPercentage = this.getScrollPercentage(dependency);
        if (fadeOut) {
            scrollPercentage = 100.0f - scrollPercentage;
        }
        child.setAlpha(maxAlpha / 100.0f * scrollPercentage);
    }

    protected float getScrollPercentage(View dependency) {
        float dependencyHeight = (float)dependency.getHeight() - this.toolbarHeight;
        float dependencyBottom = (float)dependency.getBottom() - this.toolbarHeight;
        return dependencyBottom / dependencyHeight * 100.0f;
    }
}

