/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.preview;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import io.intercom.android.sdk.UnreadConversationCountListener;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.preview.DefaultLauncher;
import io.intercom.android.sdk.preview.LauncherOpenBehaviour;
import io.intercom.android.sdk.store.UnreadCountTracker;

class DefaultLauncherManager
implements UnreadConversationCountListener,
DefaultLauncher.Listener {
    private final LayoutInflater inflater;
    private final MetricsStore.Provider metricsStoreProvider;
    private final AppConfig.Provider appConfigProvider;
    private final LauncherOpenBehaviour openBehaviour;
    @Nullable
    private DefaultLauncher defaultLauncher;
    private UnreadCountTracker unreadCountTracker;
    private int previousUnreadCount = 0;

    DefaultLauncherManager(LayoutInflater inflater, UnreadCountTracker unreadCountTracker, MetricsStore.Provider metricsStoreProvider, AppConfig.Provider appConfigProvider, LauncherOpenBehaviour openBehaviour) {
        this.inflater = inflater;
        this.unreadCountTracker = unreadCountTracker;
        this.metricsStoreProvider = metricsStoreProvider;
        this.appConfigProvider = appConfigProvider;
        this.openBehaviour = openBehaviour;
    }

    void displayLauncherOnAttachedRoot(ViewGroup root) {
        if (this.defaultLauncher == null) {
            this.defaultLauncher = new DefaultLauncher(root.getContext(), root, this.inflater, this.appConfigProvider.getAppConfig(), this);
            this.setUnreadCount(this.unreadCountTracker.getCount());
            this.defaultLauncher.fadeOnScreen();
            this.unreadCountTracker.addListener(this);
        } else {
            this.setUnreadCount(this.unreadCountTracker.getCount());
        }
    }

    DefaultLauncher getLauncher() {
        DefaultLauncher localLauncher = this.defaultLauncher;
        this.defaultLauncher = null;
        return localLauncher;
    }

    public void reset() {
        this.unreadCountTracker.removeListener(this);
        this.removeLauncher();
    }

    @VisibleForTesting
    void removeLauncher() {
        if (this.defaultLauncher != null) {
            this.defaultLauncher.fadeOffScreen();
            this.defaultLauncher = null;
        }
    }

    public boolean isDisplaying() {
        return this.defaultLauncher != null;
    }

    @Override
    public void onCountUpdate(int unreadCount) {
        this.setUnreadCount(unreadCount);
    }

    private void setUnreadCount(int unreadCount) {
        String unreadCountText = String.valueOf(unreadCount);
        if (this.isDisplaying()) {
            if (unreadCount > this.previousUnreadCount) {
                this.metricsStoreProvider.getMetricsStore().track(MetricFactory.receivedNotificationFromBadgeWhenMessengerClosed(unreadCountText));
            }
            if (unreadCount > 0) {
                this.defaultLauncher.setBadgeCount(unreadCountText);
            } else {
                this.defaultLauncher.hideBadeCount();
            }
        }
        this.previousUnreadCount = unreadCount;
    }

    @Override
    public void onLauncherClicked(Context context) {
        this.openBehaviour.openMessenger(context);
    }
}

