/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.support.annotation.NonNull;
import io.intercom.android.sdk.conversation.events.AdminIsTypingEvent;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.models.events.realtime.CreateConversationEvent;
import io.intercom.android.sdk.models.events.realtime.NewCommentEvent;
import io.intercom.android.sdk.models.events.realtime.UserContentSeenByAdminEvent;
import io.intercom.android.sdk.nexus.NexusClient;
import io.intercom.android.sdk.nexus.NexusConfig;
import io.intercom.android.sdk.nexus.NexusEvent;
import io.intercom.android.sdk.nexus.NexusListener;
import io.intercom.com.squareup.otto.Bus;

public class NexusWrapper
extends NexusClient
implements NexusListener {
    private final Bus bus;

    public NexusWrapper(Bus bus) {
        this.bus = bus;
    }

    public void connect(NexusConfig config, boolean shouldSendPresence) {
        if (!this.isConnected() && !config.getEndpoints().isEmpty()) {
            super.connect(config, shouldSendPresence);
            this.addEventListener(this);
        }
    }

    public void disconnect() {
        this.removeEventListener(this);
        super.disconnect();
    }

    public void cycle(NexusConfig config, boolean shouldSendPresence) {
        this.disconnect();
        this.connect(config, shouldSendPresence);
    }

    public void notifyEvent(@NonNull NexusEvent event) {
        switch (event.getEventType()) {
            case AdminIsTyping: {
                IntercomLogger.internal("nexus realtime", "received " + event.getEventType() + " event");
                this.bus.post((Object)new AdminIsTypingEvent(event.getAdminId(), event.getConversationId(), event.getAdminName(), event.getAdminAvatarUrl()));
                break;
            }
            case NewComment: {
                IntercomLogger.internal("nexus realtime", "received " + event.getEventType() + " event");
                this.bus.post((Object)new NewCommentEvent(event.getConversationId()));
                break;
            }
            case CreateConversation: {
                IntercomLogger.internal("nexus realtime", "received " + event.getEventType() + " event");
                this.bus.post((Object)new CreateConversationEvent());
                break;
            }
            case UserContentSeenByAdmin: {
                IntercomLogger.internal("realtime", "received " + event.getEventType() + " event");
                this.bus.post((Object)new UserContentSeenByAdminEvent(event.getConversationId()));
                break;
            }
            default: {
                IntercomLogger.internal("nexus realtime", "unexpected event: " + event.getEventType());
            }
        }
    }

    public void onConnect() {
    }

    public void onConnectFailed() {
    }
}

