/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views.holder;

import android.content.ClipboardManager;
import android.content.Context;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.views.PartMetadataFormatter;
import io.intercom.android.sdk.views.holder.ConversationListener;
import io.intercom.android.sdk.views.holder.ConversationViewHolder;

public class PartViewHolder
extends ConversationViewHolder {
    private final int viewType;
    private final TextView time;
    private final PartMetadataFormatter partMetadataFormatter;
    private LinearLayout blocks;

    public PartViewHolder(View itemView, int viewType, ConversationListener conversationListener, @Nullable ClipboardManager clipboardManager, Context context) {
        super(itemView, conversationListener, clipboardManager, context);
        this.viewType = viewType;
        this.time = (TextView)itemView.findViewById(R.id.rowTime);
        this.partMetadataFormatter = PartMetadataFormatter.create(this.time, context);
    }

    @Override
    public void bind(Part part) {
        boolean shouldConcatenate = this.shouldConcatenate(part, this.getAdapterPosition());
        this.blocks = this.setUpHolderBlocks(part, this.cellLayout, this.bubble, this.infoIcon);
        this.setupHolderBackground(this.viewType, part, shouldConcatenate);
        this.setupMetaData(this.viewType, part);
        this.checkForEntranceAnimation(this.viewType, part, this.networkAvatar, this.cellLayout, this.blocks);
        if (this.bubble != null) {
            this.bubble.setExpanded(this.shouldExpand(part), false);
        }
    }

    private boolean shouldExpand(Part part) {
        return this.isSelectedPart(part) || this.isLastPart(part) || this.isNextPartTyping(this.getAdapterPosition() + 1);
    }

    @VisibleForTesting
    public boolean isSelectedPart(Part part) {
        return part == this.conversationListener.getSelectedPart();
    }

    @VisibleForTesting
    public boolean isLastPart(Part part) {
        return part == this.conversationListener.getPart(this.conversationListener.getCount() - 1) && !"admin_is_typing_style".equals(part.getMessageStyle());
    }

    @VisibleForTesting
    public boolean isNextPartTyping(int nextPos) {
        return nextPos <= this.conversationListener.getCount() - 1 && "admin_is_typing_style".equals(this.conversationListener.getPart(nextPos).getMessageStyle());
    }

    protected void setupHolderBackground(int type, Part conversationPart, boolean shouldConcatenate) {
        this.setBubbleBackground(conversationPart, this.blocks, type);
        if (this.networkAvatar != null) {
            if (shouldConcatenate) {
                this.networkAvatar.setVisibility(4);
            } else if (type == 1 || type == 5 || type == 4) {
                this.showAvatar(conversationPart.getParticipant(), this.networkAvatar);
            }
        }
    }

    public void onClick(View v) {
        this.conversationListener.onPartClicked(this.getAdapterPosition(), this);
    }

    public void setExpanded(boolean expanded) {
        if (this.bubble != null) {
            this.bubble.setExpanded(expanded, true);
        }
    }

    private void setupMetaData(int type, Part conversationPart) {
        if (this.time == null) {
            return;
        }
        boolean isLastItem = conversationPart == this.conversationListener.getPart(this.conversationListener.getCount() - 1);
        String metadataText = this.partMetadataFormatter.getMetadataString(type, conversationPart, isLastItem);
        if (metadataText != null) {
            this.time.setText((CharSequence)metadataText);
        }
    }
}

