/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.UnreadConversationCountListener;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.SimpleAnimatorListener;
import io.intercom.android.sdk.views.InboxCountDrawable;

public class IntercomToolbar
extends Toolbar
implements View.OnClickListener,
UnreadConversationCountListener {
    public static final int TITLE_FADE_DURATION_MS = 150;
    private final InboxCountDrawable inboxCountDrawable;
    private final TextView title;
    private final TextView subtitle;
    private final ImageButton close;
    private final ImageButton inbox;
    private final ImageView avatar;
    @Nullable
    private Listener listener;

    public IntercomToolbar(Context context) {
        this(context, null);
    }

    public IntercomToolbar(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        View toolbar = IntercomToolbar.inflate((Context)context, (int)R.layout.intercom_iam_toolbar, (ViewGroup)this);
        this.title = (TextView)toolbar.findViewById(R.id.intercom_toolbar_title);
        this.subtitle = (TextView)toolbar.findViewById(R.id.intercom_toolbar_subtitle);
        this.close = (ImageButton)toolbar.findViewById(R.id.intercom_toolbar_close);
        this.inbox = (ImageButton)toolbar.findViewById(R.id.intercom_toolbar_inbox);
        this.avatar = (ImageView)toolbar.findViewById(R.id.intercom_toolbar_avatar);
        this.inboxCountDrawable = new InboxCountDrawable(this.getContext(), null);
        this.inbox.setOnClickListener((View.OnClickListener)this);
        this.close.setOnClickListener((View.OnClickListener)this);
    }

    public void setNavigationItem(boolean shouldShowBack) {
        if (shouldShowBack) {
            this.inbox.setImageDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.intercom_back));
        } else {
            this.inbox.setImageDrawable((Drawable)this.inboxCountDrawable);
        }
    }

    public void setListener(@Nullable Listener listener) {
        this.listener = listener;
    }

    public void setUpFullToolbar() {
        this.setBackgroundColor(Injector.get().getAppIdentity().getAppConfig().getBaseColor());
        this.avatar.setVisibility(8);
    }

    public void setUpPostToolbar(Avatar adminAvatar) {
        this.setBackgroundColor(0);
        this.title.setTextColor(-1);
        this.close.setColorFilter(-1);
        this.inbox.setVisibility(8);
        this.avatar.setVisibility(0);
        this.setTitleMarginTop(this.getResources().getDimensionPixelSize(R.dimen.intercom_toolbar_post_margin));
        this.title.setTextSize(14.0f);
        this.subtitle.setAlpha(0.7f);
        this.findViewById(R.id.intercom_toolbar_divider).setVisibility(0);
        AvatarUtils.createAvatar(adminAvatar, this.avatar, this.getContext());
    }

    public void setUpNoteToolbar(Avatar adminAvatar) {
        this.setBackgroundResource(R.drawable.intercom_note_toolbar);
        this.title.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.intercom_note_title_grey));
        this.subtitle.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.intercom_note_grey));
        this.close.setColorFilter(ContextCompat.getColor((Context)this.getContext(), (int)R.color.intercom_grey_500));
        this.inbox.setVisibility(8);
        this.avatar.setVisibility(0);
        this.setTitleMarginTop(this.getResources().getDimensionPixelSize(R.dimen.intercom_toolbar_note_margin));
        this.title.setTextSize(14.0f);
        this.subtitle.setAlpha(1.0f);
        View divider = this.findViewById(R.id.intercom_toolbar_divider);
        divider.setVisibility(0);
        divider.setBackgroundColor(-16777216);
        AvatarUtils.createAvatar(adminAvatar, this.avatar, this.getContext());
    }

    public void setInboxButtonVisibility(int visible) {
        this.inbox.setVisibility(visible);
    }

    public void setTitle(CharSequence titleText) {
        if (TextUtils.isEmpty((CharSequence)titleText)) {
            ObjectAnimator animator2 = ObjectAnimator.ofFloat((Object)this.title, (Property)View.ALPHA, (float[])new float[]{this.title.getAlpha(), 0.0f}).setDuration(150L);
            animator2.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

                @Override
                public void onAnimationEnd(Animator animation) {
                    IntercomToolbar.this.title.setText(null);
                }
            });
            animator2.start();
        } else {
            this.title.setAlpha(1.0f);
            this.title.setText(titleText);
        }
    }

    public void setSubtitle(@Nullable CharSequence subtitleText) {
        this.subtitle.setText(subtitleText);
        if (!TextUtils.isEmpty((CharSequence)subtitleText)) {
            this.subtitle.setAlpha(1.0f);
        }
    }

    public void fadeOutInbox() {
        ObjectAnimator animator2 = ObjectAnimator.ofFloat((Object)this.title, (Property)View.ALPHA, (float[])new float[]{this.title.getAlpha(), 0.0f}).setDuration(150L);
        animator2.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                IntercomToolbar.this.title.setText(null);
            }
        });
        animator2.start();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            Injector.get().getUnreadCountTracker().addListener(this);
            this.onCountUpdate(Injector.get().getUnreadCountTracker().getCount());
        }
    }

    protected void onDetachedFromWindow() {
        Injector.get().getUnreadCountTracker().removeListener(this);
        super.onDetachedFromWindow();
    }

    public void onClick(View view) {
        if (this.listener != null) {
            int id2 = view.getId();
            if (id2 == R.id.intercom_toolbar_close) {
                this.listener.onCloseClicked();
            } else if (id2 == R.id.intercom_toolbar_inbox) {
                this.listener.onInboxClicked();
                this.setInboxButtonVisibility(8);
                AppConfig appConfig = Injector.get().getAppIdentity().getAppConfig();
                this.setTitle(String.format(this.getContext().getString(R.string.intercom_chats_with), appConfig.getName()));
                this.setSubtitle("");
                Injector.get().getMetricsStore().track(MetricFactory.tappedIntoInbox());
            }
        }
    }

    @Override
    public void onCountUpdate(int count) {
        this.inboxCountDrawable.setText(count > 0 ? Integer.toString(count) : null);
    }

    private void setTitleMarginTop(int marginTop) {
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.title.getLayoutParams();
        params.setMargins(params.leftMargin, marginTop, params.rightMargin, params.bottomMargin);
        this.title.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public static interface Listener {
        public void onCloseClicked();

        public void onInboxClicked();
    }
}

