/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;

public class InboxCountDrawable
extends Drawable {
    private static final String COUNT_BACKGROUND_COLOR = "#FE536C";
    private static final int ICON_PADDING_DP = 19;
    private static final int COUNT_BACKGROUND_RADIUS_DP = 8;
    private static final int COUNT_TEXT_SIZE_DP = 11;
    private static final int COUNT_TEXT_PADDING_TOP = 4;
    private static final int ICON_SIZE_DP = 18;
    private final Drawable inboxIcon;
    private final int iconPadding;
    private final int iconSize;
    private final Paint countBackgroundPaint;
    private final int countBackgroundRadius;
    private final int textTopPadding;
    private final Paint textPaint;
    @Nullable
    private String text;

    public InboxCountDrawable(Context context, @Nullable String text) {
        this.text = text;
        this.inboxIcon = ContextCompat.getDrawable((Context)context, (int)R.drawable.intercom_inbox);
        this.iconPadding = ScreenUtils.convertDpToPixel((float)19.0f, (Context)context);
        this.iconSize = ScreenUtils.convertDpToPixel((float)18.0f, (Context)context);
        this.countBackgroundPaint = new Paint();
        this.countBackgroundPaint.setColor(Color.parseColor((String)COUNT_BACKGROUND_COLOR));
        this.countBackgroundPaint.setStyle(Paint.Style.FILL);
        this.countBackgroundRadius = ScreenUtils.convertDpToPixel((float)8.0f, (Context)context);
        this.textPaint = new Paint();
        this.textPaint.setColor(-1);
        this.textPaint.setTextSize((float)ScreenUtils.convertDpToPixel((float)11.0f, (Context)context));
        this.textPaint.setFakeBoldText(true);
        this.textPaint.setStyle(Paint.Style.FILL);
        this.textPaint.setTextAlign(Paint.Align.CENTER);
        this.textTopPadding = ScreenUtils.convertDpToPixel((float)4.0f, (Context)context);
    }

    public void draw(Canvas canvas) {
        Rect bounds = this.getBounds();
        int iconLeft = bounds.left + this.iconPadding;
        int iconTop = bounds.top + this.iconPadding;
        int iconRight = iconLeft + this.iconSize;
        int iconBottom = iconTop + this.iconSize;
        this.inboxIcon.setBounds(iconLeft, iconTop, iconRight, iconBottom);
        this.inboxIcon.draw(canvas);
        if (!TextUtils.isEmpty((CharSequence)this.text)) {
            canvas.drawCircle((float)iconRight, (float)iconTop, (float)this.countBackgroundRadius, this.countBackgroundPaint);
            canvas.drawText(this.text, (float)iconRight, (float)(iconTop + this.textTopPadding), this.textPaint);
        }
    }

    public void setAlpha(int alpha) {
        this.textPaint.setAlpha(alpha);
        this.countBackgroundPaint.setAlpha(alpha);
        this.inboxIcon.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.inboxIcon.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return -1;
    }

    public void setText(@Nullable String text) {
        this.text = text;
        this.invalidateSelf();
    }
}

