/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.photoview.gestures;

import android.content.Context;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;
import io.intercom.android.sdk.photoview.Compat;
import io.intercom.android.sdk.photoview.gestures.GestureDetector;
import io.intercom.android.sdk.photoview.gestures.OnGestureListener;

public class GestureDetectorImpl
implements GestureDetector {
    protected OnGestureListener listener;
    private static final int INVALID_POINTER_ID = -1;
    private int activePointerId = -1;
    private int activePointerIndex = 0;
    float lastTouchX;
    float lastTouchY;
    float firstTouchX;
    float firstTouchY;
    final float touchSlop;
    final float minimumVelocity;
    protected final ScaleGestureDetector detector;
    private VelocityTracker velocityTracker;
    private boolean isDragging;

    public GestureDetectorImpl(Context context, OnGestureListener listener) {
        this.listener = listener;
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.minimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.touchSlop = configuration.getScaledTouchSlop();
        ScaleGestureDetector.OnScaleGestureListener mScaleListener = new ScaleGestureDetector.OnScaleGestureListener(){

            public boolean onScale(ScaleGestureDetector detector) {
                float scaleFactor = detector.getScaleFactor();
                if (Float.isNaN(scaleFactor) || Float.isInfinite(scaleFactor)) {
                    return false;
                }
                GestureDetectorImpl.this.listener.onScale(scaleFactor, detector.getFocusX(), detector.getFocusY());
                return true;
            }

            public boolean onScaleBegin(ScaleGestureDetector detector) {
                return true;
            }

            public void onScaleEnd(ScaleGestureDetector detector) {
            }
        };
        this.detector = new ScaleGestureDetector(context, mScaleListener);
    }

    float getActiveX(MotionEvent ev) {
        return ev.getRawX();
    }

    float getActiveY(MotionEvent ev) {
        return ev.getRawY();
    }

    @Override
    public boolean isScaling() {
        return this.detector.isInProgress();
    }

    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        this.detector.onTouchEvent(ev);
        int action = ev.getAction();
        switch (action & 0xFF) {
            case 0: {
                this.activePointerId = ev.getPointerId(0);
                this.velocityTracker = VelocityTracker.obtain();
                if (null != this.velocityTracker) {
                    this.velocityTracker.addMovement(ev);
                }
                this.lastTouchX = this.getActiveX(ev);
                this.lastTouchY = this.getActiveY(ev);
                this.firstTouchX = this.lastTouchX;
                this.firstTouchY = this.lastTouchY;
                this.isDragging = false;
                break;
            }
            case 2: {
                float x = this.getActiveX(ev);
                float y = this.getActiveY(ev);
                float dx = x - this.lastTouchX;
                float dy = y - this.lastTouchY;
                int fingers = ev.getPointerCount();
                if (!this.isDragging && !this.isScaling() && fingers == 1) {
                    boolean bl = this.isDragging = Math.sqrt(dx * dx + dy * dy) >= (double)this.touchSlop;
                }
                if (!this.isDragging || this.isScaling() || fingers != 1) break;
                float dirX = x - this.firstTouchX;
                float dirY = y - this.firstTouchY;
                float distance = (float)Math.sqrt((this.firstTouchX - x) * (this.firstTouchX - x) + (this.firstTouchY - y) * (this.firstTouchY - y));
                this.listener.onDrag(dirX, dirY, distance);
                this.lastTouchX = x;
                this.lastTouchY = y;
                if (null == this.velocityTracker) break;
                this.velocityTracker.addMovement(ev);
                break;
            }
            case 3: {
                if (null == this.velocityTracker) break;
                this.velocityTracker.recycle();
                this.velocityTracker = null;
                break;
            }
            case 1: {
                this.activePointerId = -1;
                break;
            }
            case 6: {
                int pointerIndex = Compat.getPointerIndex(ev.getAction());
                int pointerId = ev.getPointerId(pointerIndex);
                if (pointerId == this.activePointerId) {
                    int newPointerIndex = pointerIndex == 0 ? 1 : 0;
                    this.activePointerId = ev.getPointerId(newPointerIndex);
                    this.lastTouchX = ev.getX(newPointerIndex);
                    this.lastTouchY = ev.getY(newPointerIndex);
                }
                if (this.isDragging && null != this.velocityTracker) {
                    this.lastTouchX = this.getActiveX(ev);
                    this.lastTouchY = this.getActiveY(ev);
                    this.velocityTracker.addMovement(ev);
                    this.velocityTracker.computeCurrentVelocity(1000);
                    float vX = this.velocityTracker.getXVelocity();
                    float vY = this.velocityTracker.getYVelocity();
                    if (Math.max(Math.abs(vX), Math.abs(vY)) >= this.minimumVelocity) {
                        this.listener.onFling(this.lastTouchX, this.lastTouchY, -vX, -vY);
                    }
                }
                if (null == this.velocityTracker) break;
                this.velocityTracker.recycle();
                this.velocityTracker = null;
                break;
            }
        }
        this.activePointerIndex = ev.findPointerIndex(this.activePointerId != -1 ? this.activePointerId : 0);
        return true;
    }

    @Override
    public boolean isDragging() {
        return this.isDragging;
    }
}

