/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.metrics;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import io.intercom.com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class MetricObject {
    static final String ACTION_MESSENGER = "messenger_action";
    static final String ACTION_MESSENGER_MESSAGE_RESPONSE = "messenger_message_response_action";
    static final String ACTION_MESSENGER_INBOX = "messenger_inbox_action";
    static final String ACTION_CUSTOM_LAUNCHER_OPT_IN = "channels_custom_launcher_opt_in";
    static final String ACTION_CUSTOM_LAUNCHER_OPT_OUT = "channels_custom_launcher_opt_out";
    static final String SUB_ACTION_TAPPED_ON_LAUNCHER = "tapped_on_launcher";
    static final String SUB_ACTION_TYPED_IN_MESSAGE_INPUT = "typed_in_message_input";
    static final String SUB_ACTION_SENT_NEW_MESSAGE = "sent_new_message";
    static final String SUB_ACTION_CLOSED_MESSENGER = "closed_messenger";
    static final String SUB_ACTION_PROFILE_EXPANDED = "profile_expanded";
    static final String SUB_ACTION_OPENED_PUSH_MESSAGE = "opened_push_message";
    static final String SUB_ACTION_TAPPED_ON_CONTENT_CARD = "tapped_on_content_card";
    static final String SUB_ACTION_TAPPED_ON_SNIPPET_IN_APP = "tapped_on_snippet_in_app";
    static final String SUB_ACTION_DISMISSED_SNIPPET_IN_APP = "dismissed_snippet_in_app";
    static final String SUB_ACTION_TAPPED_ON_FULL_IN_APP = "tapped_on_full_in_app";
    static final String SUB_ACTION_DISMISSED_FULL_IN_APP = "dismissed_full_in_app";
    static final String SUB_ACTION_TAPPED_INTO_INBOX = "tapped_into_inbox";
    static final String SUB_ACTION_TAPPED_ON_MESSAGE_FROM_INBOX = "tapped_on_message_from_inbox";
    static final String SUB_ACTION_TAPPED_ON_NEW_CHAT_BUTTON = "tapped_on_new_chat_button";
    static final String SUB_ACTION_REACTIONS_DISPLAYED = "reactions_displayed";
    static final String SUB_ACTION_SELECTED_REACTION = "selected_reaction";
    public static final String KEY_ANDROID_INSTALLER_PACKAGE_NAME = "android_installer_package_name";
    public static final String KEY_ANDROID_IS_DEBUG_BUILD = "android_is_debug_build";
    public static final String KEY_CONVERSATION_ID = "conversation_id";
    public static final String KEY_END_USER_ID = "end_user_id";
    public static final String KEY_SUB_ACTION = "sub_action";
    public static final String KEY_LAUNCHER_TYPE = "launcher_type";
    public static final String VAL_DEFAULT_LAUNCHER = "default";
    public static final String VAL_CUSTOM_LAUNCHER = "custom";
    public static final String KEY_PROFILE_TYPE = "profile_type";
    public static final String VAL_TEAMMATE_PROFILE = "teammate";
    public static final String VAL_TEAM_PROFILE = "team";
    public static final String KEY_NEW_MESSAGE_TYPE = "new_message_type";
    public static final String KEY_TYPING_MESSAGE_TYPE = "typing_message_type";
    public static final String VAL_NEW_CONVERSATION = "new_conversation";
    public static final String VAL_REPLY = "reply";
    public static final String KEY_PUSH_TYPE = "push_type";
    public static final String VAL_PUSH_ONLY = "push_only";
    public static final String VAL_PUSH_IN_APP = "in_app";
    public static final String KEY_MESSAGE_STYLE = "message_style";
    private final Map<String, Object> metadata = new HashMap<String, Object>();
    private final String id;
    private final String name;
    @SerializedName(value="created_at")
    private final long createdAt;

    MetricObject(String name, String subAction, String intercomId) {
        this.name = name;
        this.createdAt = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        this.id = UUID.randomUUID().toString();
        this.metadata.put(KEY_SUB_ACTION, subAction);
        if (!TextUtils.isEmpty((CharSequence)intercomId)) {
            this.metadata.put(KEY_END_USER_ID, intercomId);
        }
    }

    public MetricObject addMetaData(String key, Object value) {
        this.metadata.put(key, value);
        return this;
    }

    MetricObject addConversationId(String conversationId) {
        this.addMetaData(KEY_CONVERSATION_ID, conversationId);
        return this;
    }

    MetricObject addIsDebugBuild(boolean isDebugBuild) {
        this.addMetaData(KEY_ANDROID_IS_DEBUG_BUILD, isDebugBuild);
        return this;
    }

    MetricObject addInstallerPackageName(@Nullable String installerPackageName) {
        if (TextUtils.isEmpty((CharSequence)installerPackageName)) {
            installerPackageName = "unknown";
        }
        this.addMetaData(KEY_ANDROID_INSTALLER_PACKAGE_NAME, installerPackageName);
        return this;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public String getName() {
        return this.name;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricObject that = (MetricObject)o;
        if (this.createdAt != that.createdAt) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        return this.name != null ? this.name.equals(that.name) : that.name == null;
    }

    public int hashCode() {
        int result = this.metadata != null ? this.metadata.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (int)(this.createdAt ^ this.createdAt >>> 32);
        return result;
    }

    public String toString() {
        return "MetricObject{metadata=" + this.metadata + ", id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", createdAt=" + this.createdAt + '}';
    }
}

