/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import android.content.res.Resources;
import android.os.Parcel;
import android.os.Parcelable;
import io.intercom.android.sdk.R;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class Location
implements Parcelable {
    private final String cityName;
    private final String countryName;
    private final String countryCode;
    private final String timezone;
    public static final Parcelable.Creator<Location> CREATOR = new Parcelable.Creator<Location>(){

        public Location createFromParcel(Parcel in) {
            return new Location(in);
        }

        public Location[] newArray(int size) {
            return new Location[size];
        }
    };

    public Location() {
        this(new Builder());
    }

    public Location(Builder builder) {
        this.cityName = builder.city_name == null ? "" : builder.city_name;
        this.countryName = builder.country_name == null ? "" : builder.country_name;
        this.countryCode = builder.country_code == null ? "" : builder.country_code;
        this.timezone = builder.timezone == null ? Calendar.getInstance().getTimeZone().getID() : builder.timezone;
    }

    protected Location(Parcel in) {
        this.cityName = in.readString();
        this.countryName = in.readString();
        this.countryCode = in.readString();
        this.timezone = in.readString();
    }

    public String getLocationString(Resources resources) {
        Date date = Calendar.getInstance().getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("K:mm aaa", Locale.getDefault());
        dateFormat.setTimeZone(TimeZone.getTimeZone(this.timezone));
        return resources.getString(R.string.intercom_profile_location, new Object[]{String.format(Locale.getDefault(), "%s", dateFormat.format(date)), this.cityName, this.countryName});
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.cityName);
        dest.writeString(this.countryName);
        dest.writeString(this.countryCode);
        dest.writeString(this.timezone);
    }

    public static final class Builder {
        private String city_name;
        private String country_name;
        private String country_code;
        private String timezone;

        public Location build() {
            return new Location(this);
        }
    }
}

