/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.identity;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import io.intercom.android.sdk.logger.IntercomLogger;
import java.util.HashMap;
import java.util.Map;

public class Registration {
    private String email = "";
    private String userId = "";
    private String registrationId = "";
    private Integer appLogo = null;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private boolean isValidRegistration = true;

    public static Registration create() {
        return new Registration();
    }

    public Registration withEmail(@NonNull String email) {
        if (TextUtils.isEmpty((CharSequence)email)) {
            IntercomLogger.e("Email cannot be null or empty");
            this.isValidRegistration = false;
        } else {
            this.email = email;
        }
        return this;
    }

    public Registration withUserId(@NonNull String userId) {
        if (TextUtils.isEmpty((CharSequence)userId)) {
            IntercomLogger.e("UserId cannot be null or empty");
            this.isValidRegistration = false;
        } else {
            this.userId = userId;
        }
        return this;
    }

    public Registration withGcmCredentials(@NonNull String registrationId, @Nullable Integer appLogo) {
        if (TextUtils.isEmpty((CharSequence)registrationId)) {
            IntercomLogger.e("GCM registration id should not be null or empty");
        } else {
            this.registrationId = registrationId;
        }
        if (appLogo == null) {
            IntercomLogger.i("No applogo provided. Falling back to default logo");
        } else {
            this.appLogo = appLogo;
        }
        return this;
    }

    public Registration withUserAttributes(Map<String, Object> attributes) {
        this.isValidRegistration = false;
        if (attributes == null) {
            IntercomLogger.e("Registration.withUserAttributes method failed: the attributes Map provided is null");
        } else if (attributes.isEmpty()) {
            IntercomLogger.e("Registration.withUserAttributes method failed: the attributes Map provided is empty");
        } else {
            this.attributes = attributes;
            this.isValidRegistration = true;
        }
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getRegistrationId() {
        return this.registrationId;
    }

    public Integer getAppLogo() {
        return this.appLogo;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    protected boolean isValidRegistration() {
        return this.isValidRegistration;
    }
}

