/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.app.Application;
import android.content.Context;
import android.support.annotation.NonNull;
import io.intercom.android.sdk.NexusWrapper;
import io.intercom.android.sdk.TeamPresenceProvider;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.DeDuper;
import io.intercom.android.sdk.api.MainThreadBus;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.lifecycles.Lifecycles;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.preview.PreviewManager;
import io.intercom.android.sdk.store.HasConversationsStore;
import io.intercom.android.sdk.store.LastViewStore;
import io.intercom.android.sdk.store.UnreadConversationIdsStore;
import io.intercom.android.sdk.store.UnreadCountTracker;
import io.intercom.com.squareup.otto.Bus;
import io.intercom.com.squareup.otto.ThreadEnforcer;

public class Injector
implements Api.Provider,
MetricsStore.Provider {
    private static Injector instance;
    private final Application application;
    private final AppIdentity appIdentity;
    private MainThreadBus bus;
    private NexusWrapper nexusClient;
    private UnreadCountTracker unreadCountTracker;
    private TeamPresenceProvider teamPresenceProvider;
    private UserIdentity userIdentity;
    private DeDuper superDeDuper;
    private Api api;
    private MetricsStore metricsStore;
    private PreviewManager previewManager;
    private UnreadConversationIdsStore unreadConversationIdsStore;
    private HasConversationsStore hasConversationsStore;
    private LastViewStore lastViewStore;

    public static synchronized void init(Application application) {
        if (instance == null) {
            AppIdentity appIdentity = new AppIdentity((Context)application);
            Injector.initWithAppCredentials(application, appIdentity.getApiKey(), appIdentity.getAppId());
        }
    }

    public static synchronized void initWithAppCredentials(Application application, String apiKey, String appId) {
        if (instance == null) {
            IntercomLogger.internal("Injector", "Initializing");
            AppIdentity appIdentity = new AppIdentity((Context)application);
            appIdentity.update(apiKey, appId);
            instance = new Injector(application, appIdentity);
            Lifecycles lifecycles = new Lifecycles(instance, instance.getDeDuper(), instance);
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)lifecycles);
        }
    }

    public Injector(Application application, AppIdentity appIdentity) {
        this.application = application;
        this.appIdentity = appIdentity;
    }

    public static Injector get() {
        return instance;
    }

    static void setSharedInstance(Injector injector) {
        instance = injector;
    }

    public Application getApplication() {
        return this.application;
    }

    @NonNull
    public AppIdentity getAppIdentity() {
        return this.appIdentity;
    }

    @NonNull
    public UserIdentity getUserIdentity() {
        if (this.userIdentity == null) {
            this.userIdentity = new UserIdentity((Context)this.getApplication());
        }
        return this.userIdentity;
    }

    public Bus getBus() {
        if (this.bus == null) {
            this.bus = new MainThreadBus(ThreadEnforcer.ANY);
        }
        return this.bus;
    }

    public NexusWrapper getNexusClient() {
        if (this.nexusClient == null) {
            this.nexusClient = new NexusWrapper(this.getBus());
            this.nexusClient.setLoggingEnabled(false);
        }
        return this.nexusClient;
    }

    public UnreadCountTracker getUnreadCountTracker() {
        if (this.unreadCountTracker == null) {
            this.unreadCountTracker = new UnreadCountTracker();
        }
        return this.unreadCountTracker;
    }

    public TeamPresenceProvider getTeamPresenceProvider() {
        if (this.teamPresenceProvider == null) {
            this.teamPresenceProvider = new TeamPresenceProvider();
        }
        return this.teamPresenceProvider;
    }

    public DeDuper getDeDuper() {
        if (this.superDeDuper == null) {
            this.superDeDuper = new DeDuper(this.getAppIdentity());
        }
        return this.superDeDuper;
    }

    @Override
    public Api getApi() {
        if (this.api == null) {
            this.api = new Api((Context)this.getApplication(), this.getAppIdentity().getAppId(), !this.getUserIdentity().hasIntercomId(), this.getAppIdentity(), this.getUserIdentity());
        }
        this.api.configureRequestSynchronicity((Context)this.getApplication(), this.getUserIdentity().hasIntercomId());
        return this.api;
    }

    @Override
    public MetricsStore getMetricsStore() {
        if (this.metricsStore == null) {
            this.metricsStore = new MetricsStore((Context)this.getApplication(), this.getApi());
            this.metricsStore.loadCachedMetrics();
        }
        return this.metricsStore;
    }

    public PreviewManager getPreviewManager() {
        if (this.previewManager == null) {
            this.previewManager = new PreviewManager(this.getApplication(), this.getBus(), this, this.getUnreadCountTracker(), this.getAppIdentity(), this.getUnreadConversationIdsStore(), this.getHasConversationsStore(), this.getLastViewStore());
        }
        return this.previewManager;
    }

    public UnreadConversationIdsStore getUnreadConversationIdsStore() {
        if (this.unreadConversationIdsStore == null) {
            this.unreadConversationIdsStore = new UnreadConversationIdsStore();
        }
        return this.unreadConversationIdsStore;
    }

    public HasConversationsStore getHasConversationsStore() {
        if (this.hasConversationsStore == null) {
            this.hasConversationsStore = new HasConversationsStore();
        }
        return this.hasConversationsStore;
    }

    public LastViewStore getLastViewStore() {
        if (this.lastViewStore == null) {
            this.lastViewStore = new LastViewStore();
        }
        return this.lastViewStore;
    }
}

