/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views.holder;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Toast;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.views.AdminIsTypingView;
import io.intercom.android.sdk.views.ExpandableLayout;
import io.intercom.android.sdk.views.holder.ConversationListener;

public abstract class ConversationViewHolder
extends RecyclerView.ViewHolder
implements View.OnClickListener,
View.OnLongClickListener {
    protected final ConversationListener conversationListener;
    @Nullable
    protected final ClipboardManager clipboardManager;
    protected final ImageView networkAvatar;
    protected final LinearLayout cellLayout;
    protected final ImageView infoIcon;
    @Nullable
    protected final ExpandableLayout bubble;
    private final String clipboardMessage;

    public ConversationViewHolder(View itemView, ConversationListener conversationListener, @Nullable ClipboardManager clipboardManager, Context context) {
        super(itemView);
        this.conversationListener = conversationListener;
        this.clipboardManager = clipboardManager;
        this.clipboardMessage = context.getResources().getString(R.string.intercom_clipboard_message);
        this.networkAvatar = (ImageView)itemView.findViewById(R.id.avatarView);
        this.cellLayout = (LinearLayout)itemView.findViewById(R.id.cellLayout);
        this.infoIcon = (ImageView)itemView.findViewById(R.id.intercom_info_icon);
        this.bubble = (ExpandableLayout)itemView.findViewById(R.id.intercom_bubble);
        itemView.setOnClickListener((View.OnClickListener)this);
        itemView.setOnLongClickListener((View.OnLongClickListener)this);
    }

    public ConversationViewHolder(View itemView, ConversationListener conversationListener, Context context) {
        this(itemView, conversationListener, null, context);
    }

    public abstract void bind(Part var1);

    protected boolean shouldConcatenate(Part conversationPart, int position) {
        if (position + 1 < this.conversationListener.getCount()) {
            Part nextPart = this.conversationListener.getPart(position + 1);
            return Part.shouldConcatenate(conversationPart, nextPart);
        }
        return false;
    }

    protected LinearLayout setUpHolderBlocks(Part conversationPart, LinearLayout cellLayout, ExpandableLayout bubble, ImageView infoIcon) {
        cellLayout.setVisibility(0);
        LinearLayout blocks = conversationPart.getLayout();
        if (blocks.getParent() != null) {
            ((LinearLayout)blocks.getParent()).removeView((View)blocks);
        }
        if (cellLayout.getChildCount() > 0) {
            cellLayout.removeAllViews();
        }
        cellLayout.addView((View)blocks, 0);
        this.setUpRowFocusRules(this.itemView, conversationPart, bubble);
        this.setUpErrorState(conversationPart, infoIcon);
        return blocks;
    }

    private void setUpRowFocusRules(View row, Part conversationPart, ExpandableLayout bubble) {
        if (bubble == null) {
            return;
        }
        bubble.setAlpha(1.0f);
        if (Part.MessageState.FAILED == conversationPart.getMessageState() || Part.MessageState.UPLOAD_FAILED == conversationPart.getMessageState()) {
            ((ViewGroup)row).setDescendantFocusability(393216);
            bubble.setAlpha(0.5f);
        }
    }

    private void setUpErrorState(Part part, ImageView infoIcon) {
        if (infoIcon != null) {
            boolean isFailedPart = part.getMessageState() == Part.MessageState.FAILED || part.getMessageState() == Part.MessageState.UPLOAD_FAILED;
            infoIcon.setVisibility(isFailedPart ? 0 : 4);
        }
    }

    protected void checkForEntranceAnimation(int type, Part part, ImageView networkAvatar, LinearLayout cellLayout, LinearLayout blocks) {
        if (part.hasEntranceAnimation()) {
            if (type == 5) {
                part.setEntranceAnimation(false);
                networkAvatar.setAlpha(0.0f);
                networkAvatar.setScaleX(0.5f);
                networkAvatar.setScaleY(0.5f);
                networkAvatar.animate().alpha(1.0f).scaleX(1.0f).scaleY(1.0f).setDuration(300L).setStartDelay(100L).start();
                cellLayout.setAlpha(0.0f);
                cellLayout.setScaleX(0.5f);
                cellLayout.setScaleY(0.5f);
                cellLayout.animate().alpha(1.0f).scaleX(1.0f).scaleY(1.0f).setDuration(300L).setStartDelay(150L).start();
                ((AdminIsTypingView)blocks.getChildAt(0)).beginAnimation();
            } else if (Part.MessageState.SENDING == part.getMessageState()) {
                part.setEntranceAnimation(false);
                cellLayout.setAlpha(0.0f);
                cellLayout.setTranslationY(cellLayout.getTranslationY() + 100.0f);
                cellLayout.animate().setStartDelay(100L).alpha(1.0f).translationYBy(-100.0f).start();
            }
        }
    }

    protected void setBubbleBackground(Part conversationPart, LinearLayout blocks, int type) {
        int pLeft = blocks.getPaddingLeft();
        int pRight = blocks.getPaddingRight();
        int pTop = blocks.getPaddingTop();
        int pBottom = blocks.getPaddingBottom();
        if (conversationPart.isImageOnly()) {
            this.cellLayout.setBackgroundColor(0);
            this.cellLayout.setPadding(0, 0, 0, 0);
            pBottom = 0;
            pTop = 0;
        } else {
            int cellPadding = (int)this.cellLayout.getContext().getResources().getDimension(R.dimen.intercom_cell_horizontal_padding);
            this.cellLayout.setPadding(cellPadding, 0, cellPadding, 0);
            if (conversationPart.isAdmin() || type == 4) {
                BackgroundUtils.setBackground((View)this.cellLayout, ContextCompat.getDrawable((Context)this.cellLayout.getContext(), (int)R.drawable.intercom_admin_block_background));
            } else {
                Drawable userBlockBackground = ContextCompat.getDrawable((Context)this.cellLayout.getContext(), (int)R.drawable.intercom_user_block_background);
                userBlockBackground.setColorFilter(Injector.get().getIdentityStore().getAppConfig().getBaseColor(), PorterDuff.Mode.SRC_IN);
                BackgroundUtils.setBackground((View)this.cellLayout, userBlockBackground);
            }
        }
        blocks.setPadding(pLeft, pTop, pRight, pBottom);
    }

    protected void showAvatar(Participant user, ImageView networkAvatar) {
        networkAvatar.setVisibility(0);
        AvatarUtils.createAvatar(user.getAvatar(), networkAvatar, this.itemView.getContext());
    }

    public boolean onLongClick(View v) {
        if (this.clipboardManager == null) {
            return false;
        }
        try {
            Part part = this.conversationListener.getPart(this.getAdapterPosition());
            ClipData clip = ClipData.newPlainText((CharSequence)"message", (CharSequence)part.getSummary());
            this.clipboardManager.setPrimaryClip(clip);
            Toast.makeText((Context)this.itemView.getContext(), (CharSequence)this.clipboardMessage, (int)0).show();
        }
        catch (Exception e) {
            IntercomLogger.internal(e.getMessage());
            return false;
        }
        return true;
    }
}

