/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.animation.AnimatorInflater;
import android.animation.AnimatorSet;
import android.annotation.TargetApi;
import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.conversation.events.AdminIsTypingEvent;
import io.intercom.android.sdk.conversation.events.AdminTypingEndedEvent;
import io.intercom.android.sdk.conversation.events.CancelAdminTypingEvent;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.com.squareup.otto.Subscribe;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

@TargetApi(value=14)
public class AdminIsTypingView
extends LinearLayout {
    private static final int IS_TYPING_DURATION_SECONDS = 10;
    private static final int ANIMATION_DELAY_MILLIS = 100;
    private final ImageView[] dots = new ImageView[3];
    private final AnimatorSet[] dotsAnimations = new AnimatorSet[3];
    private final String partId;
    private final String adminId;
    private final String conversationId;
    private final Runnable endAnimationRunnable = new Runnable(){

        @Override
        public void run() {
            AdminIsTypingView.this.endAnimation();
        }
    };
    private boolean animating = false;
    private ScheduledFuture endAnimationFuture;
    @Nullable
    private ScheduledFuture animationFuture;

    public AdminIsTypingView(Context context) {
        this(context, "", "", "");
    }

    public AdminIsTypingView(Context context, AttributeSet attrs) {
        this(context, "", "", "");
    }

    public AdminIsTypingView(Context context, String adminId, String conversationId, String partId) {
        super(context);
        AdminIsTypingView.inflate((Context)this.getContext(), (int)R.layout.intercom_admin_is_typing, (ViewGroup)this);
        this.adminId = adminId;
        this.conversationId = conversationId;
        this.partId = partId;
        this.dots[0] = (ImageView)this.findViewById(R.id.dot1);
        this.dots[1] = (ImageView)this.findViewById(R.id.dot2);
        this.dots[2] = (ImageView)this.findViewById(R.id.dot3);
        for (int i = 0; i < this.dotsAnimations.length; ++i) {
            this.dotsAnimations[i] = (AnimatorSet)AnimatorInflater.loadAnimator((Context)this.getContext(), (int)R.animator.intercomsdk_admin_is_typing);
            this.dotsAnimations[i].setStartDelay((long)(i * 100));
        }
        this.setupEndCondition();
        Injector.get().getBus().register((Object)this);
    }

    public void beginAnimation() {
        if (!this.animating) {
            this.animating = true;
            this.animationFuture = Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < AdminIsTypingView.this.dots.length; ++i) {
                        final int j = i;
                        AdminIsTypingView.this.dots[i].post(new Runnable(){

                            @Override
                            public void run() {
                                AdminIsTypingView.this.dotsAnimations[j].setTarget((Object)AdminIsTypingView.this.dots[j]);
                                AdminIsTypingView.this.dotsAnimations[j].start();
                            }
                        });
                    }
                }
            }, 0L, 1L, TimeUnit.SECONDS);
        }
    }

    private void endAnimation() {
        this.animating = false;
        Injector.get().getBus().unregister((Object)this);
        Injector.get().getBus().post((Object)new AdminTypingEndedEvent(this.adminId, this.conversationId, this.partId));
        IntercomLogger.internal("isTyping", "ending animation");
        if (this.animationFuture != null && !this.animationFuture.isCancelled()) {
            this.animationFuture.cancel(true);
        }
        if (!this.endAnimationFuture.isCancelled()) {
            this.endAnimationFuture.cancel(true);
        }
        for (AnimatorSet set : this.dotsAnimations) {
            set.cancel();
        }
    }

    private void setupEndCondition() {
        this.endAnimationFuture = Executors.newSingleThreadScheduledExecutor().schedule(this.endAnimationRunnable, 10L, TimeUnit.SECONDS);
    }

    @Subscribe
    public void renewTypingAnimation(AdminIsTypingEvent event) {
        if (event.getAdminId().equals(this.adminId) && event.getConversationId().equals(this.conversationId)) {
            this.endAnimationFuture.cancel(true);
            this.setupEndCondition();
        }
    }

    @Subscribe
    public void cancelTypingAnimation(CancelAdminTypingEvent ignored) {
        this.endAnimation();
    }
}

