/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.preview;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.preview.PreviewCallbacks;
import io.intercom.android.sdk.preview.Snippet;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.FontUtils;
import io.intercom.android.sdk.utilities.SimpleAnimatorListener;
import io.intercom.com.facebook.rebound.SimpleSpringListener;
import io.intercom.com.facebook.rebound.Spring;
import io.intercom.com.facebook.rebound.SpringListener;
import io.intercom.com.facebook.rebound.SpringSystem;

public class NotificationSnippet
extends Snippet
implements View.OnTouchListener {
    private final Handler handler;

    public NotificationSnippet(Context context, Conversation conversation, int position, SpringSystem springSystem, Handler handler, int screenHeight, PreviewCallbacks previewCallbacks) {
        super(context, conversation, position, springSystem, screenHeight, previewCallbacks);
        this.handler = handler;
    }

    @Override
    public void moveBackward(ViewGroup rootView, SimpleAnimatorListener animationListener) {
        ++this.position;
        this.animateToPosition(rootView.getContext());
    }

    @Override
    public void display(ViewGroup root, LayoutInflater inflater, boolean withFullAnimation) {
        this.setupView(root, inflater);
        this.setViewData();
        if (withFullAnimation) {
            this.animateOnScreen(root.getContext());
        } else {
            this.notificationRoot.setVisibility(0);
        }
    }

    @Override
    public void update(Conversation conversation, Runnable updateEndAction) {
        this.conversation = conversation;
        View textContainer = this.notificationRoot.findViewById(R.id.notification_root);
        View text = this.notificationRoot.findViewById(R.id.preview_summary);
        this.performReplyPulse(textContainer, text, updateEndAction);
    }

    @Override
    protected void pulseUpdate() {
        this.setViewData();
    }

    private void setupView(ViewGroup root, LayoutInflater inflater) {
        if (this.notificationRoot == null) {
            this.notificationRoot = (LinearLayout)inflater.inflate(R.layout.intercom_preview_notification, root, false);
        }
        if (!this.isAttached()) {
            root.addView((View)this.notificationRoot, 0);
        }
    }

    private void setViewData() {
        Context context = this.notificationRoot.getContext();
        TextView adminName = (TextView)this.notificationRoot.findViewById(R.id.preview_name);
        FontUtils.setTypeface(context, adminName, "intercom_roboto_medium.ttf");
        adminName.setTextColor(Injector.get().getIdentityStore().getAppConfig().getBaseColor());
        adminName.setText((CharSequence)this.getHeaderText(adminName.getContext()));
        ((TextView)this.notificationRoot.findViewById(R.id.preview_summary)).setText((CharSequence)this.conversation.getLastPart().getSummary());
        AvatarUtils.createAvatar(this.conversation.getLastAdmin().getAvatar(), (ImageView)this.notificationRoot.findViewById(R.id.preview_avatar), context);
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.notificationRoot.getLayoutParams();
        layoutParams.bottomMargin = ScreenUtils.convertDpToPixel((float)(32 + 8 * this.position), (Context)context);
        if (Build.VERSION.SDK_INT >= 21) {
            this.notificationRoot.setElevation((float)(18 - 3 * this.position));
        }
        this.notificationRoot.setScaleX(1.0f - (float)this.position * 0.05f);
        if (this.position == 0) {
            this.beginListeningForTouchEvents();
        }
    }

    private void animateOnScreen(Context context) {
        int rootHeight = ScreenUtils.convertDpToPixel((float)88.0f, (Context)context);
        int margin = ScreenUtils.convertDpToPixel((float)(32 + 8 * this.position), (Context)context);
        final int dy = this.screenHeight - (rootHeight + margin);
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                NotificationSnippet.this.spring.removeAllListeners();
                NotificationSnippet.this.spring.setCurrentValue((double)NotificationSnippet.this.screenHeight);
                NotificationSnippet.this.spring.setEndValue((double)dy);
                NotificationSnippet.this.spring.addListener((SpringListener)new SimpleSpringListener(){

                    public void onSpringActivate(Spring spring) {
                        NotificationSnippet.this.notificationRoot.setVisibility(0);
                    }

                    public void onSpringUpdate(Spring spring) {
                        NotificationSnippet.this.notificationRoot.setY((float)spring.getCurrentValue());
                    }
                });
            }
        }, (long)(this.position * 70));
    }

    @Override
    protected void onPreviewPressed(View view) {
    }

    @Override
    protected void onPreviewReleased(View view) {
    }
}

