/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.lifecycles;

import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.Gcm;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.DeDuper;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricsStore;
import java.util.HashSet;
import java.util.Set;

public class Lifecycles
implements Application.ActivityLifecycleCallbacks {
    private static final int SESSION_TIMEOUT = 20000;
    private static boolean backgrounded = true;
    private final Set<String> attachedActivities = new HashSet<String>();
    private final MetricsStore metricsStore;
    private final DeDuper deDuper;
    private final Api api;
    private long enteredBackgroundAt = 0L;

    public Lifecycles(Api api, DeDuper deDuper, MetricsStore metricsStore) {
        this.deDuper = deDuper;
        this.api = api;
        this.metricsStore = metricsStore;
    }

    public static boolean isAppBackgrounded() {
        return backgrounded;
    }

    private static boolean isScreenLocked() {
        KeyguardManager keyguardManager = (KeyguardManager)Injector.get().getContext().getSystemService("keyguard");
        return keyguardManager.inKeyguardRestrictedInputMode();
    }

    private void attachActivity(Activity activity) {
        this.attachedActivities.add(activity.getClass().getName());
    }

    private void detachActivity(Activity activity) {
        this.attachedActivities.remove(activity.getClass().getName());
    }

    @VisibleForTesting
    boolean isApplicationInBackground(Activity activity) {
        return Lifecycles.isScreenLocked() || this.attachedActivities.isEmpty() && !activity.isChangingConfigurations();
    }

    @VisibleForTesting
    boolean hasApplicationBecomeBackgrounded(Activity activity) {
        return this.isApplicationInBackground(activity) && !backgrounded;
    }

    private void appEnteredBackground(Activity activity) {
        backgrounded = true;
        IntercomLogger.internal("lifecycles", "backgrounded");
        Injector.get().getNexusClient().disconnect();
        this.enteredBackgroundAt = System.currentTimeMillis();
        this.deDuper.reset();
        this.metricsStore.sendMetrics();
    }

    private void appEnteredForeground(Activity activity) {
        backgrounded = false;
        IntercomLogger.internal("lifecycles", "foregrounded");
        if (System.currentTimeMillis() - this.enteredBackgroundAt > 20000L) {
            this.api.ping();
            IntercomLogger.internal("sdk ping", "backgrounded ping from lifecycles");
        }
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
        IntercomLogger.internal("lifecycles", "on create");
        Injector.init(activity.getApplication());
    }

    public void onActivityStarted(Activity activity) {
        IntercomLogger.internal("lifecycles", "on start");
        Injector.init(activity.getApplication());
        this.attachActivity(activity);
        if (backgrounded) {
            this.appEnteredForeground(activity);
        }
        Injector.get().getNexusClient().connect(Injector.get().getIdentityStore().getAppConfig().getRealTimeConfig(), true);
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityResumed(Activity activity) {
        IntercomLogger.internal("lifecycles", "on resume");
        Injector.init(activity.getApplication());
        this.attachActivity(activity);
        Gcm.clearNotifications((Context)activity);
    }

    public void onActivityPaused(Activity activity) {
        IntercomLogger.internal("lifecycles", "on pause");
        this.detachActivity(activity);
    }

    public void onActivityStopped(Activity activity) {
        IntercomLogger.internal("lifecycles", "on stop");
        if (this.hasApplicationBecomeBackgrounded(activity)) {
            this.appEnteredBackground(activity);
        } else {
            this.detachActivity(activity);
        }
    }

    public void onActivityDestroyed(Activity activity) {
        IntercomLogger.internal("lifecycles", "on destroy");
    }
}

