/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.view.LayoutInflater;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.Attachment;
import io.intercom.android.sdk.blocks.BlockType;
import io.intercom.android.sdk.blocks.Blocks;
import io.intercom.android.sdk.blocks.BlocksViewHolder;
import io.intercom.android.sdk.blocks.Button;
import io.intercom.android.sdk.blocks.Code;
import io.intercom.android.sdk.blocks.Facebook;
import io.intercom.android.sdk.blocks.Heading;
import io.intercom.android.sdk.blocks.LocalAttachment;
import io.intercom.android.sdk.blocks.LocalImage;
import io.intercom.android.sdk.blocks.NetworkImage;
import io.intercom.android.sdk.blocks.OrderedList;
import io.intercom.android.sdk.blocks.Paragraph;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.Subheading;
import io.intercom.android.sdk.blocks.Twitter;
import io.intercom.android.sdk.blocks.UnorderedList;
import io.intercom.android.sdk.blocks.Video;
import io.intercom.android.sdk.blocks.blockInterfaces.AttachmentListBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.ButtonBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.CodeBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.FacebookBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.HeadingBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.ImageBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.LocalAttachmentBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.LocalImageBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.OrderedListBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.ParagraphBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.SubheadngBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.TwitterBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.UnorderedListBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.VideoBlock;
import io.intercom.android.sdk.blocks.models.Block;
import io.intercom.android.sdk.blocks.models.BlockAttachment;
import io.intercom.android.sdk.models.Attachments;
import io.intercom.android.sdk.models.Part;
import java.util.ArrayList;
import java.util.List;

public class ViewHolderGenerator {
    private final Context context;

    public ViewHolderGenerator(Context context) {
        this.context = context;
    }

    public BlocksViewHolder getAdminHolder() {
        return this.generateHolder(R.layout.intercom_blocks_admin_layout, StyleType.ADMIN);
    }

    public BlocksViewHolder getUserHolder() {
        return this.generateHolder(R.layout.intercom_blocks_user_layout, StyleType.USER);
    }

    public BlocksViewHolder getPreviewHolder() {
        return this.generateHolder(R.layout.intercom_blocks_user_layout, StyleType.PREVIEW);
    }

    public BlocksViewHolder getPostHolder() {
        return this.generateHolder(R.layout.intercom_blocks_post_layout, StyleType.POST);
    }

    public BlocksViewHolder getNoteHolder() {
        return this.generateHolder(R.layout.intercom_blocks_note_layout, StyleType.NOTE);
    }

    public BlocksViewHolder getContainerCardHolder() {
        return this.generateHolder(R.layout.intercom_blocks_container_card_layout, StyleType.CONTAINER_CARD);
    }

    private BlocksViewHolder generateHolder(int layoutId, StyleType style) {
        BlocksViewHolder holder = new BlocksViewHolder();
        LayoutInflater inflater = LayoutInflater.from((Context)this.context);
        holder.setLayout(layoutId);
        holder.setParagraph((ParagraphBlock)new Paragraph(inflater, style));
        holder.setHeading((HeadingBlock)new Heading(this.context, inflater, style));
        holder.setSubheading((SubheadngBlock)new Subheading(inflater, style));
        holder.setCode((CodeBlock)new Code(inflater, style));
        holder.setUnorderedList((UnorderedListBlock)new UnorderedList(this.context, inflater, style));
        holder.setOrderedList((OrderedListBlock)new OrderedList(this.context, inflater, style));
        holder.setImage((ImageBlock)new NetworkImage(this.context, inflater, style));
        holder.setLocalImage((LocalImageBlock)new LocalImage(this.context, inflater, style));
        holder.setButton((ButtonBlock)new Button(this.context, inflater, style));
        holder.setAttachmentList((AttachmentListBlock)new Attachment(this.context, inflater, style));
        holder.setLocalAttachment((LocalAttachmentBlock)new LocalAttachment(this.context, inflater, style));
        holder.setTwitterButton((TwitterBlock)new Twitter(this.context, inflater, style));
        holder.setFacebookButton((FacebookBlock)new Facebook(this.context, inflater, style));
        holder.setVideo((VideoBlock)new Video(this.context, inflater, style));
        return holder;
    }

    public static void createPartUi(BlocksViewHolder blocksNoteViewHolder, Part part, Context context) {
        List<Block> blockParts = part.getBlocks();
        Blocks blocks = new Blocks(context);
        if (!part.getAttachments().isEmpty()) {
            ArrayList<BlockAttachment> blockAttachments = new ArrayList<BlockAttachment>();
            for (Attachments attachment : part.getAttachments()) {
                blockAttachments.add(new BlockAttachment.Builder().withName(attachment.getName()).withUrl(attachment.getUrl()).build());
            }
            Block attachmentBlock = new Block.Builder().withType(BlockType.ATTACHMENTLIST.name()).withAttachments(blockAttachments).build();
            blockParts.add(attachmentBlock);
        }
        if (!blockParts.isEmpty()) {
            part.setLayout(blocks.createBlocks(blockParts, blocksNoteViewHolder));
        }
    }
}

