/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.UnreadConversationCountListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class UnreadCountTracker {
    @VisibleForTesting
    final List<UnreadConversationCountListener> listeners = new CopyOnWriteArrayList<UnreadConversationCountListener>();
    private final AtomicInteger count = new AtomicInteger();

    public int getCount() {
        return this.count.get();
    }

    public void incrementCount() {
        this.updateListeners(this.count.incrementAndGet());
    }

    public void decrementCount() {
        this.updateListeners(this.count.decrementAndGet());
    }

    public void updateCount(int newCount) {
        this.count.set(newCount);
        this.updateListeners(newCount);
    }

    public void addListener(@NonNull UnreadConversationCountListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(UnreadConversationCountListener listener) {
        this.listeners.remove(listener);
    }

    private void updateListeners(int newCount) {
        for (UnreadConversationCountListener listener : this.listeners) {
            listener.onCountUpdate(newCount);
        }
    }
}

