/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.Context;
import android.graphics.PorterDuff;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;

public class BlockUtils {
    public static void setLayoutMarginsAndGravity(View view, int gravity, boolean shouldStripBottomPadding) {
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)view.getLayoutParams();
        if (shouldStripBottomPadding) {
            params.setMargins(params.leftMargin, params.topMargin, params.rightMargin, 0);
        }
        params.gravity = gravity;
    }

    public static View getBlockView(ViewGroup parent, LinearLayout blocks, Context context) {
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        View row = inflater.inflate(R.layout.intercom_container_layout, parent, false);
        ProgressBar spinner = (ProgressBar)row.findViewById(R.id.loading_wheel);
        if (spinner != null) {
            int baseColor = Injector.get().getIdentityStore().getAppConfig().getBaseColor();
            spinner.getIndeterminateDrawable().setColorFilter(baseColor, PorterDuff.Mode.SRC_IN);
        }
        LinearLayout cellLayout = (LinearLayout)row.findViewById(R.id.cellLayout);
        if (blocks.getParent() != null) {
            ((LinearLayout)blocks.getParent()).removeView((View)blocks);
        }
        if (cellLayout.getChildCount() > 0) {
            cellLayout.removeAllViews();
        }
        cellLayout.addView((View)blocks, 0);
        row.setFocusable(false);
        cellLayout.setVisibility(0);
        return row;
    }
}

