/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.preview;

import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.UnreadConversationCountListener;
import io.intercom.android.sdk.preview.BaseManager;
import io.intercom.android.sdk.preview.DefaultLauncher;
import io.intercom.android.sdk.preview.PreviewInteractionManager;

public class DefaultLauncherManager
extends BaseManager
implements UnreadConversationCountListener {
    @Nullable
    private DefaultLauncher defaultLauncher;

    public DefaultLauncherManager(LayoutInflater inflater, PreviewInteractionManager interactionManager) {
        super(inflater, interactionManager);
    }

    public void displayLauncher(final ViewGroup root) {
        this.waitForRootViewAttachment(root, new Runnable(){

            @Override
            public void run() {
                if (DefaultLauncherManager.this.defaultLauncher == null) {
                    DefaultLauncherManager.this.defaultLauncher = new DefaultLauncher(root.getContext(), root, DefaultLauncherManager.this.inflater);
                    DefaultLauncherManager.this.setUnreadCount(Injector.get().getUnreadCountTracker().getCount());
                    DefaultLauncherManager.this.defaultLauncher.fadeOnScreen();
                    Injector.get().getUnreadCountTracker().addListener(DefaultLauncherManager.this);
                } else {
                    DefaultLauncherManager.this.setUnreadCount(Injector.get().getUnreadCountTracker().getCount());
                }
            }
        });
    }

    public DefaultLauncher getLauncher() {
        DefaultLauncher localLauncher = this.defaultLauncher;
        this.defaultLauncher = null;
        return localLauncher;
    }

    public void softReset() {
        Injector.get().getUnreadCountTracker().removeListener(this);
        this.removeLauncher();
    }

    public void reset() {
        this.softReset();
    }

    public void removeLauncher() {
        if (this.defaultLauncher != null) {
            this.defaultLauncher.fadeOffScreen();
            this.defaultLauncher = null;
        }
    }

    public boolean isDisplaying() {
        return this.defaultLauncher != null;
    }

    @Override
    public void onCountUpdate(int unreadCount) {
        this.setUnreadCount(unreadCount);
    }

    private void setUnreadCount(int unreadCount) {
        if (this.defaultLauncher != null) {
            if (unreadCount > 0) {
                this.defaultLauncher.setBadgeCount(String.valueOf(unreadCount));
            } else {
                this.defaultLauncher.hideBadeCount();
            }
        }
    }
}

