/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.widget.LinearLayout;
import io.intercom.android.sdk.annotations.Exclude;
import io.intercom.android.sdk.blocks.BlockType;
import io.intercom.android.sdk.blocks.models.Block;
import io.intercom.android.sdk.models.Attachments;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.ReactionReply;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class Part
implements Parcelable {
    public static final String POST_MESSAGE_STYLE = "post";
    public static final String NOTE_MESSAGE_STYLE = "note";
    public static final String CHAT_MESSAGE_STYLE = "chat";
    public static final String ADMIN_IS_TYPING_STYLE = "admin_is_typing_style";
    public static final String DAY_DIVIDER = "day_divider_style";
    public static final String LOADING_LAYOUT = "loading_layout_style";
    private List<Attachments> attachments;
    private List<Block> blocks;
    private String id;
    private String participantId;
    private String messageStyle;
    private boolean participantIsAdmin;
    private boolean showCreatedAt;
    private long createdAt;
    private DeliveryOption deliveryOption;
    private String summary;
    private ReactionReply reactionReply;
    private String seenByAdmin;
    private MessageState messageState;
    private Participant participant;
    private Uri fileUri;
    private String footer;
    private boolean firstChatPart;
    private boolean displayDelivered;
    private boolean entranceAnimation;
    private boolean isImageOnly;
    @Exclude
    private LinearLayout layout;
    public static final Parcelable.Creator<Part> CREATOR = new Parcelable.Creator<Part>(){

        public Part createFromParcel(Parcel in) {
            return new Part(in);
        }

        public Part[] newArray(int size) {
            return new Part[size];
        }
    };

    public Part() {
        this(new Builder());
    }

    private Part(Builder builder) {
        this.id = builder.id == null ? UUID.randomUUID().toString() : builder.id;
        this.participantId = builder.participant_id == null ? "" : builder.participant_id;
        this.participantIsAdmin = builder.participant_is_admin;
        this.showCreatedAt = builder.show_created_at;
        this.summary = builder.summary == null ? "" : builder.summary;
        this.createdAt = builder.created_at;
        this.messageStyle = Part.convertLegacyMessageStyle(builder.message_style);
        if (builder.delivery_option != null) {
            try {
                this.deliveryOption = DeliveryOption.valueOf(builder.delivery_option.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.deliveryOption = DeliveryOption.SUMMARY;
            }
        } else {
            this.deliveryOption = DeliveryOption.SUMMARY;
        }
        this.blocks = new ArrayList<Block>();
        if (builder.body != null) {
            for (Block.Builder blockBuilder : builder.body) {
                this.blocks.add(blockBuilder.build());
            }
        }
        this.reactionReply = builder.reactions_reply == null ? new ReactionReply.NullReactionReply() : builder.reactions_reply.build();
        this.seenByAdmin = builder.seen_by_admin == null ? "hide" : builder.seen_by_admin;
        this.attachments = new ArrayList<Attachments>();
        if (builder.attachments != null) {
            for (Attachments.Builder attachmentBuilder : builder.attachments) {
                this.attachments.add(attachmentBuilder.build());
            }
        }
        this.footer = "";
        this.participant = Participant.NULL;
        this.footer = "";
        this.displayDelivered = false;
        this.entranceAnimation = false;
        this.firstChatPart = false;
        this.messageState = MessageState.NORMAL;
        this.isImageOnly = this.blocks.size() == 1 && this.blocks.get(0).getType() == BlockType.IMAGE;
        this.fileUri = new Uri.Builder().build();
    }

    public DeliveryOption getDeliveryOption() {
        return this.deliveryOption;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id2) {
        this.id = id2;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public boolean showCreatedAt() {
        return this.showCreatedAt;
    }

    public void setShowCreatedAt(boolean showCreatedAt) {
        this.showCreatedAt = showCreatedAt;
    }

    public boolean isAdmin() {
        return this.participantIsAdmin;
    }

    public void setParticipantIsAdmin(boolean participantIsAdmin) {
        this.participantIsAdmin = participantIsAdmin;
    }

    public List<Block> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(List<Block> blocks) {
        this.blocks = blocks;
    }

    public List<Attachments> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachments> attachments) {
        this.attachments = attachments;
    }

    public String getMessageStyle() {
        return this.messageStyle;
    }

    public void setMessageStyle(String messageStyle) {
        this.messageStyle = messageStyle;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public String getSummary() {
        return this.summary;
    }

    public ReactionReply getReactionReply() {
        return this.reactionReply;
    }

    public String getSeenByAdmin() {
        return this.participantIsAdmin ? "hide" : this.seenByAdmin;
    }

    public void setSeenByAdmin(String seenByAdmin) {
        this.seenByAdmin = seenByAdmin;
    }

    public Participant getParticipant() {
        return this.participant;
    }

    public void setParticipant(Participant participant) {
        this.participant = participant;
        this.participantId = participant.getId();
    }

    public LinearLayout getLayout() {
        return this.layout;
    }

    public void setLayout(LinearLayout layout2) {
        this.layout = layout2;
    }

    public String getFooter() {
        return this.footer;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public boolean isDisplayDelivered() {
        return this.displayDelivered;
    }

    public void setDisplayDelivered(boolean displayDelivered) {
        this.displayDelivered = displayDelivered;
    }

    public boolean hasEntranceAnimation() {
        return this.entranceAnimation;
    }

    public void setEntranceAnimation(boolean entranceAnimation) {
        this.entranceAnimation = entranceAnimation;
    }

    public boolean isFirstChatPart() {
        return this.firstChatPart;
    }

    public void setFirstChatPart(boolean firstChatPart) {
        this.firstChatPart = firstChatPart;
    }

    public MessageState getMessageState() {
        return this.messageState;
    }

    public void setMessageState(MessageState messageState) {
        this.messageState = messageState;
    }

    public boolean isImageOnly() {
        return this.isImageOnly;
    }

    public void isImageOnly(boolean isImageOnly) {
        this.isImageOnly = isImageOnly;
    }

    public Uri getFileUri() {
        return this.fileUri;
    }

    public void setFileUri(Uri fileUri) {
        this.fileUri = fileUri;
    }

    static String convertLegacyMessageStyle(String legacyStyle) {
        if ("announcement".equals(legacyStyle)) {
            return POST_MESSAGE_STYLE;
        }
        if ("small-announcement".equals(legacyStyle)) {
            return NOTE_MESSAGE_STYLE;
        }
        if (ADMIN_IS_TYPING_STYLE.equals(legacyStyle)) {
            return ADMIN_IS_TYPING_STYLE;
        }
        if (DAY_DIVIDER.equals(legacyStyle)) {
            return DAY_DIVIDER;
        }
        if (LOADING_LAYOUT.equals(legacyStyle)) {
            return LOADING_LAYOUT;
        }
        return CHAT_MESSAGE_STYLE;
    }

    protected Part(Parcel in) {
        this.id = in.readString();
        this.participantId = in.readString();
        boolean bl = this.participantIsAdmin = in.readByte() != 0;
        if (in.readByte() == 1) {
            this.blocks = new ArrayList<Block>();
            in.readList(this.blocks, Block.class.getClassLoader());
        } else {
            this.blocks = null;
        }
        if (in.readByte() == 1) {
            this.attachments = new ArrayList<Attachments>();
            in.readList(this.attachments, Attachments.class.getClassLoader());
        } else {
            this.attachments = null;
        }
        this.messageStyle = in.readString();
        this.createdAt = in.readLong();
        this.summary = in.readString();
        boolean isNullReaction = in.readByte() == 0;
        this.reactionReply = isNullReaction ? new ReactionReply.NullReactionReply() : (ReactionReply)in.readValue(ReactionReply.class.getClassLoader());
        this.seenByAdmin = in.readString();
        this.participant = (Participant)in.readValue(Participant.class.getClassLoader());
        this.footer = in.readString();
        this.showCreatedAt = in.readByte() != 0;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeString(this.participantId);
        dest.writeByte((byte)(this.participantIsAdmin ? 1 : 0));
        if (this.blocks == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeList(this.blocks);
        }
        if (this.attachments == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeList(this.attachments);
        }
        dest.writeString(this.messageStyle);
        dest.writeLong(this.createdAt);
        dest.writeString(this.summary);
        if (this.reactionReply instanceof ReactionReply.NullReactionReply) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeValue((Object)this.reactionReply);
        }
        dest.writeString(this.seenByAdmin);
        dest.writeValue((Object)this.participant);
        dest.writeString(this.footer);
        dest.writeByte((byte)(this.showCreatedAt ? 1 : 0));
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Part) {
            Part otherPart = (Part)o;
            return this.id.equals(otherPart.id);
        }
        return false;
    }

    public static boolean shouldConcatenate(Part part, Part nextPart) {
        long threeMins;
        long diff = Math.abs(nextPart.getCreatedAt() - part.getCreatedAt());
        return diff < (threeMins = TimeUnit.MINUTES.toSeconds(3L)) && !Part.nextPartFromOtherParticipant(part, nextPart) && nextPart.getCreatedAt() != 0L;
    }

    private static boolean nextPartFromOtherParticipant(Part part, Part nextPart) {
        return !part.getParticipantId().equals(nextPart.getParticipantId());
    }

    public static final class NullPart
    extends Part {
        public NullPart() {
            super(new Builder());
        }
    }

    public static final class Builder {
        private String id;
        private String participant_id;
        private boolean participant_is_admin;
        private boolean show_created_at;
        private List<Block.Builder> body;
        private List<Attachments.Builder> attachments;
        private String message_style;
        private long created_at;
        private String summary;
        private ReactionReply.Builder reactions_reply;
        private String delivery_option;
        private String seen_by_admin;

        public Builder withStyle(String style) {
            this.message_style = style;
            return this;
        }

        public Builder withCreatedAt(long createdAt) {
            this.created_at = createdAt;
            return this;
        }

        public Builder withParticipantIsAdmin(boolean participantIsAdmin) {
            this.participant_is_admin = participantIsAdmin;
            return this;
        }

        public Part build() {
            return new Part(this);
        }
    }

    public static enum DeliveryOption {
        FULL,
        SUMMARY,
        BADGE;

    }

    public static enum MessageState {
        SENDING,
        FAILED,
        UPLOAD_FAILED,
        NORMAL;

    }
}

