/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.inbox;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.os.Build;
import android.os.Bundle;
import android.support.design.widget.FloatingActionButton;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Property;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EdgeEffect;
import android.widget.ProgressBar;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.fragments.IntercomSupportFragment;
import io.intercom.android.sdk.inbox.ConversationsHolder;
import io.intercom.android.sdk.inbox.InboxAdapter;
import io.intercom.android.sdk.interfaces.RecyclerViewClickListener;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.ConversationList;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.events.ConversationEvent;
import io.intercom.android.sdk.models.events.InboxEvent;
import io.intercom.android.sdk.models.events.NewConversationEvent;
import io.intercom.android.sdk.models.events.ReadEvent;
import io.intercom.android.sdk.models.events.ReplyEvent;
import io.intercom.android.sdk.models.events.failure.InboxFailedEvent;
import io.intercom.android.sdk.models.events.realtime.CreateConversationEvent;
import io.intercom.android.sdk.models.events.realtime.NewCommentEvent;
import io.intercom.android.sdk.utilities.SimpleAnimatorListener;
import io.intercom.android.sdk.views.EndlessRecyclerScrollListener;
import io.intercom.android.sdk.views.EndlessScrollListener;
import io.intercom.android.sdk.views.IntercomErrorView;
import io.intercom.com.squareup.otto.Subscribe;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

@TargetApi(value=15)
public class ConversationsListFragment
extends IntercomSupportFragment
implements View.OnClickListener,
RecyclerViewClickListener,
EndlessScrollListener {
    protected ConversationsHolder conversationsHolder;
    private View rootView;
    private RecyclerView inboxView;
    private IntercomErrorView inboxErrorView;
    private View loadingView;
    private FloatingActionButton floatingActionButton;
    private ProgressBar progressBar;
    private LinearLayoutManager layoutManager;
    private EndlessRecyclerScrollListener endlessRecyclerScrollListener;
    private Listener listener;
    private InboxAdapter adapter;
    private String openConversationId = "";
    private boolean loading;

    public static ConversationsListFragment getInstance() {
        return new ConversationsListFragment();
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Injector.init(this.getActivity().getApplication());
        this.loading = true;
        this.conversationsHolder = new ConversationsHolder();
        this.adapter = new InboxAdapter(this.getActivity().getLayoutInflater(), this.conversationsHolder, this, Injector.get().getTeamPresenceProvider());
        this.layoutManager = new LinearLayoutManager((Context)this.getActivity());
        this.endlessRecyclerScrollListener = new EndlessRecyclerScrollListener(this.layoutManager, this);
        Injector.get().getBus().register((Object)this);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        IntercomLogger.internal("inbox frag", "creating view for fragment");
        if (this.rootView == null) {
            this.rootView = inflater.inflate(R.layout.intercom_fragment_inbox, container, false);
            this.loadingView = this.rootView.findViewById(R.id.progressBar);
            this.inboxErrorView = (IntercomErrorView)this.rootView.findViewById(R.id.error_layout);
            this.inboxView = (RecyclerView)this.rootView.findViewById(R.id.inbox_recycler_view);
            this.floatingActionButton = (FloatingActionButton)this.rootView.findViewById(R.id.compose_action_button);
            this.progressBar = (ProgressBar)this.rootView.findViewById(R.id.progressBar);
            this.inboxView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
            this.inboxView.addOnScrollListener((RecyclerView.OnScrollListener)this.endlessRecyclerScrollListener);
            this.inboxView.setAdapter((RecyclerView.Adapter)this.adapter);
            this.floatingActionButton.setOnClickListener((View.OnClickListener)this);
            this.inboxErrorView.setActionButtonClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ConversationsListFragment.this.displayLoadingView();
                    ConversationsListFragment.this.fetchNewConversations();
                }
            });
            this.displayLoadingView();
            this.fetchNewConversations();
        } else {
            ViewGroup parent = (ViewGroup)this.rootView.getParent();
            if (parent != null) {
                parent.removeView(this.rootView);
            }
        }
        this.setColorScheme();
        this.openConversationId = "";
        this.decideInboundCapability();
        this.adapter.notifyDataSetChanged();
        return this.rootView;
    }

    public void onResume() {
        this.inboxView.setAlpha(1.0f);
        if (!this.loading) {
            if (this.conversationsHolder.isEmpty()) {
                this.displayEmptyView();
            } else {
                this.displayInbox();
            }
        }
        super.onResume();
    }

    public void onDestroy() {
        Injector.get().getBus().unregister((Object)this);
        super.onDestroyView();
    }

    public void onClick(View view) {
        if (view.getId() == R.id.compose_action_button) {
            this.fadeOutInbox(new SimpleAnimatorListener(){

                @Override
                public void onAnimationEnd(Animator animation) {
                    ConversationsListFragment.this.listener.loadConversation("", new LastParticipatingAdmin.NullLastParticipant(), true, true);
                }
            });
            Injector.get().getMetricsStore().track(MetricFactory.tappedOnNewChatButton());
        }
    }

    @Override
    public void onViewClicked(int position) {
        final Conversation conversation = (Conversation)this.conversationsHolder.get(position);
        this.openConversationId = conversation.getId();
        this.fadeOutInbox(new SimpleAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                ConversationsListFragment.this.listener.loadConversation(conversation.getId(), conversation.getLastParticipatingAdmin(), conversation.getRead(), true);
            }
        });
        Injector.get().getMetricsStore().track(MetricFactory.tappedOnMessageFromInbox(conversation.getId()));
    }

    @Override
    public void onSupportAttach(Context context) {
        super.onSupportAttach(context);
        try {
            this.listener = (Listener)context;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(context + " must implement ConversationsListFragment.Listener");
        }
    }

    public void onDetach() {
        super.onDetach();
        this.listener = null;
    }

    private void fadeOutInbox(SimpleAnimatorListener endListener) {
        this.listener.inboxRowSelected();
        ObjectAnimator animator2 = ObjectAnimator.ofFloat((Object)this.inboxView, (Property)View.ALPHA, (float[])new float[]{this.inboxView.getAlpha(), 0.0f}).setDuration(150L);
        animator2.addListener((Animator.AnimatorListener)endListener);
        animator2.start();
    }

    private void decideInboundCapability() {
        if (Injector.get().getIdentityStore().getAppConfig().isInboundMessages()) {
            this.floatingActionButton.setVisibility(0);
        } else {
            this.floatingActionButton.setVisibility(8);
        }
    }

    private void displayInbox() {
        if (this.isAdded()) {
            this.inboxView.setVisibility(0);
            this.floatingActionButton.setVisibility(0);
            this.inboxErrorView.setVisibility(8);
            this.loadingView.setVisibility(8);
        }
    }

    private void displayError() {
        if (this.isAdded()) {
            this.inboxErrorView.setTitle(R.string.intercom_inbox_error_state_title);
            String subtitle = String.format(this.getString(R.string.intercom_empty_conversations), Injector.get().getIdentityStore().getAppConfig().getName());
            this.inboxErrorView.setSubtitle(subtitle);
            this.inboxErrorView.setActionButtonText(R.string.intercom_tap_to_retry);
            this.inboxErrorView.setActionButtonVisibility(0);
            this.inboxErrorView.setVisibility(0);
            this.inboxView.setVisibility(8);
            this.loadingView.setVisibility(8);
            this.floatingActionButton.setVisibility(8);
        }
    }

    private void displayEmptyView() {
        if (this.isAdded()) {
            this.inboxErrorView.setTitle(R.string.intercom_no_messages);
            String subtitle = String.format(this.getString(R.string.intercom_empty_conversations), Injector.get().getIdentityStore().getAppConfig().getName());
            this.inboxErrorView.setSubtitle(subtitle);
            this.inboxErrorView.setActionButtonVisibility(8);
            this.inboxErrorView.setVisibility(0);
            this.floatingActionButton.setVisibility(0);
            this.inboxView.setVisibility(8);
            this.loadingView.setVisibility(8);
        }
    }

    private void displayLoadingView() {
        if (this.isAdded()) {
            this.inboxErrorView.setVisibility(8);
            this.inboxView.setVisibility(8);
            this.floatingActionButton.setVisibility(8);
            this.loadingView.setVisibility(0);
        }
    }

    private void addLoadingCell() {
        Conversation.Loading loadingCell = new Conversation.Loading();
        this.conversationsHolder.add(loadingCell);
        this.adapter.notifyItemInserted(this.conversationsHolder.size() - 1);
    }

    private void removeLoadingCell() {
        int numConversations = this.conversationsHolder.size();
        if (numConversations > 0 && this.conversationsHolder.get(numConversations - 1) instanceof Conversation.Loading) {
            this.conversationsHolder.remove(numConversations - 1);
            this.adapter.notifyItemRemoved(numConversations - 1);
        }
    }

    private void fetchNewConversations() {
        Injector.get().getApi().getInbox();
    }

    private void realtimeUpdate() {
        this.fetchNewConversations();
    }

    @Subscribe
    public void inboxSuccess(InboxEvent event) {
        ConversationList list = event.getResponse();
        this.endlessRecyclerScrollListener.setMorePagesAvailable(list.hasMorePages());
        this.removeLoadingCell();
        this.conversationsHolder.syncInbox(list.getConversations(), this.adapter, this.layoutManager);
        this.loading = false;
        if (this.isAdded()) {
            this.setColorScheme();
            if (list.getConversations().isEmpty() && this.conversationsHolder.isEmpty()) {
                this.displayEmptyView();
            } else {
                this.displayInbox();
            }
            this.decideInboundCapability();
        }
    }

    private void setColorScheme() {
        int baseColor = Injector.get().getIdentityStore().getAppConfig().getBaseColor();
        this.progressBar.getIndeterminateDrawable().setColorFilter(baseColor, PorterDuff.Mode.SRC_IN);
        this.floatingActionButton.setBackgroundTintList(ColorStateList.valueOf((int)baseColor));
        this.listener.setStatusBarColor();
        this.listener.setToolbarColor();
    }

    @Subscribe
    public void inboxFailedToLoad(InboxFailedEvent event) {
        if (this.isAdded()) {
            this.displayError();
        }
    }

    @Subscribe
    public void newComment(NewCommentEvent event) {
        if (!event.getConversationId().equals(this.openConversationId)) {
            this.realtimeUpdate();
        }
    }

    @Subscribe
    public void newConversation(CreateConversationEvent event) {
        this.realtimeUpdate();
    }

    @Subscribe
    public void markedAsRead(ReadEvent event) {
        for (Conversation conversation : this.conversationsHolder) {
            if (!conversation.getId().equals(event.getConversationId()) || conversation.getRead().booleanValue()) continue;
            conversation.setRead(true);
            this.conditionallyNotifyDataSetChanged();
            break;
        }
    }

    @Subscribe
    public void newConversationEvent(NewConversationEvent event) {
        Conversation newConversation = event.getResponse();
        if (!this.conversationsHolder.contains(newConversation)) {
            this.conversationsHolder.add(0, newConversation);
            this.conditionallyNotifyDataSetChanged();
        }
    }

    @Subscribe
    public void conversationRefresh(ConversationEvent event) {
        Conversation newConversation = event.getResponse();
        for (int i = 0; i < this.conversationsHolder.size(); ++i) {
            Conversation conversation = (Conversation)this.conversationsHolder.get(i);
            if (!conversation.getId().equals(newConversation.getId())) continue;
            this.conversationsHolder.remove(i);
            this.conversationsHolder.add(i, newConversation);
            if (!newConversation.getRead().booleanValue() && conversation.getRead().booleanValue() && !newConversation.getId().equals(this.openConversationId)) {
                Injector.get().getUnreadCountTracker().incrementCount();
            }
            this.conditionallyNotifyDataSetChanged();
            break;
        }
    }

    @Subscribe
    public void replyInConversation(ReplyEvent event) {
        for (int i = 0; i < this.conversationsHolder.size(); ++i) {
            if (!((Conversation)this.conversationsHolder.get(i)).getId().equals(event.getConversationId())) continue;
            Conversation conversation = (Conversation)this.conversationsHolder.remove(i);
            conversation.getParts().add(event.getResponse());
            this.conversationsHolder.add(0, conversation);
            this.conditionallyNotifyDataSetChanged();
            break;
        }
    }

    private void conditionallyNotifyDataSetChanged() {
        if (this.isAdded()) {
            this.adapter.notifyDataSetChanged();
        }
    }

    @Override
    public void onLoadMore() {
        if (!this.loading) {
            this.loading = true;
            Conversation conversation = this.conversationsHolder.getLastConversation();
            if (conversation != null) {
                Injector.get().getApi().getInboxBefore(conversation.getLastPart().getCreatedAt());
                this.addLoadingCell();
            }
        }
    }

    @Override
    public void setOverScrollColour() {
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                Class<RecyclerView> clazz = RecyclerView.class;
                for (String name : new String[]{"ensureTopGlow", "ensureBottomGlow"}) {
                    Method method = clazz.getDeclaredMethod(name, new Class[0]);
                    method.setAccessible(true);
                    method.invoke((Object)this.inboxView, new Object[0]);
                }
                for (String name : new String[]{"mTopGlow", "mBottomGlow"}) {
                    Field field = clazz.getDeclaredField(name);
                    field.setAccessible(true);
                    Object edge = field.get(this.inboxView);
                    Field edgeEffect = edge.getClass().getDeclaredField("mEdgeEffect");
                    edgeEffect.setAccessible(true);
                    ((EdgeEffect)edgeEffect.get(edge)).setColor(Injector.get().getIdentityStore().getAppConfig().getBaseColor());
                }
            }
            catch (Exception ignored) {
                IntercomLogger.d("Could not set overscroll colour");
            }
        }
    }

    public static interface Listener {
        public void loadConversation(String var1, LastParticipatingAdmin var2, boolean var3, boolean var4);

        public void inboxRowSelected();

        public void setStatusBarColor();

        public void setToolbarColor();
    }
}

