/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation.lightbox;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.PorterDuff;
import android.os.Bundle;
import android.view.MotionEvent;
import android.widget.ImageView;
import android.widget.ProgressBar;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.conversation.lightbox.LightboxPresenter;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.photoview.DefaultOnDoubleTapListener;
import io.intercom.android.sdk.photoview.PhotoViewAttacher;
import io.intercom.android.sdk.utilities.ImageUtils;
import io.intercom.android.sdk.views.AttachedImageView;
import io.intercom.com.bumptech.glide.DrawableTypeRequest;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.load.resource.drawable.GlideDrawable;
import io.intercom.com.bumptech.glide.request.RequestListener;
import io.intercom.com.bumptech.glide.request.target.Target;

public class LightboxActivity
extends Activity {
    public static final String IMAGE_URL = "image_url";
    public static final String IMAGE_WIDTH = "image_width";
    public static final String IMAGE_HEIGHT = "image_height";
    private static final float MAXIMUM_SCALE = 8.0f;
    private static final float MEDIUM_SCALE = 3.5f;
    private static final String TAG = LightboxActivity.class.getSimpleName();
    private LightboxPresenter presenter;
    private AttachedImageView imageView;
    private ProgressBar progressBar;

    public static Intent createIntent(Context context, int width, int height, String url) {
        Intent intent = new Intent(context, LightboxActivity.class);
        intent.putExtra(IMAGE_URL, url);
        intent.putExtra(IMAGE_WIDTH, width);
        intent.putExtra(IMAGE_HEIGHT, height);
        intent.setFlags(0x10000000);
        return intent;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.intercom_activity_lightbox);
        final Bundle extras = this.getIntent().getExtras();
        if (extras == null) {
            IntercomLogger.e("Invalid parameters used, cannot display image");
            this.finish();
            return;
        }
        this.presenter = new LightboxPresenter(this);
        this.imageView = (AttachedImageView)this.findViewById(R.id.lightbox_image);
        this.imageView.setOnAttachedToWindowListener(new AttachedImageView.OnAttachedToWindowListener(){

            @Override
            public void callback() {
                String url = extras.getString(LightboxActivity.IMAGE_URL, "");
                int width = extras.getInt(LightboxActivity.IMAGE_WIDTH, 0);
                int height = extras.getInt(LightboxActivity.IMAGE_HEIGHT, 0);
                LightboxActivity.this.presenter.prepareImage(url, width, height, LightboxActivity.this.imageView.isHardwareAccelerated());
            }
        });
        AppConfig appConfig = Injector.get().getIdentityStore().getAppConfig();
        this.progressBar = (ProgressBar)this.findViewById(R.id.loading_wheel);
        this.progressBar.getIndeterminateDrawable().setColorFilter(appConfig.getBaseColor(), PorterDuff.Mode.SRC_IN);
    }

    protected void displayImage(String url, int targetWidth, int targetHeight) {
        DrawableTypeRequest requestCreator = Glide.with((Activity)this).load(url);
        if (targetWidth > 0 || targetHeight > 0) {
            requestCreator.override(targetWidth, targetHeight);
        }
        requestCreator.listener((RequestListener)new RequestListener<String, GlideDrawable>(){

            public boolean onException(Exception e, String model, Target<GlideDrawable> target, boolean isFirstResource) {
                IntercomLogger.internal(TAG, "Image load failed: " + e.getMessage());
                return false;
            }

            public boolean onResourceReady(GlideDrawable resource, String model, Target<GlideDrawable> target, boolean isFromMemoryCache, boolean isFirstResource) {
                PhotoViewAttacher photoViewAttacher = new PhotoViewAttacher(LightboxActivity.this.imageView);
                photoViewAttacher.setOnDoubleTapListener(new DefaultOnDoubleTapListener(photoViewAttacher){

                    @Override
                    public boolean onSingleTapConfirmed(MotionEvent e) {
                        LightboxActivity.this.finish();
                        return super.onSingleTapConfirmed(e);
                    }
                });
                photoViewAttacher.setMaximumScale(8.0f);
                photoViewAttacher.setMediumScale(3.5f);
                LightboxActivity.this.progressBar.setVisibility(8);
                LightboxActivity.this.imageView.setVisibility(0);
                return false;
            }
        }).diskCacheStrategy(ImageUtils.getDiskCacheStrategy(url)).into((ImageView)this.imageView);
    }
}

