/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.blockInterfaces.AttachmentListBlock;
import io.intercom.android.sdk.blocks.models.BlockAttachment;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.IntentUtils;
import java.util.List;

@TargetApi(value=11)
public class Attachment
implements AttachmentListBlock {
    private static final int ATTACHMENT_LINE_SPACING_DP = 12;
    private final LayoutInflater inflater;
    private final StyleType style;
    private final Context context;

    public Attachment(Context context, StyleType style) {
        this.style = style;
        this.context = context;
        this.inflater = LayoutInflater.from((Context)context);
    }

    public View addAttachmentList(List<BlockAttachment> attachments, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        LinearLayout layout2 = (LinearLayout)this.inflater.inflate(R.layout.intercom_blocks_attachment_list, parent, false);
        int count = attachments.size();
        for (int i = 0; i < count; ++i) {
            final BlockAttachment attachment = attachments.get(i);
            LinearLayout attachmentLayout = (LinearLayout)this.inflater.inflate(R.layout.intercom_blocks_attachment, (ViewGroup)layout2, false);
            TextView attachmentText = (TextView)attachmentLayout.findViewById(R.id.attachment_text);
            attachmentText.setText((CharSequence)attachment.getName());
            attachmentText.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    Uri uri = Uri.parse((String)attachment.getUrl());
                    if (!Uri.EMPTY.equals((Object)uri)) {
                        Intent intent = new Intent("android.intent.action.VIEW", uri);
                        intent.setFlags(0x10000000);
                        IntentUtils.safelyOpenIntent(Attachment.this.context, intent);
                    }
                }
            });
            View attachmentDivider = attachmentLayout.findViewById(R.id.attachment_divider);
            if (this.style == StyleType.USER || this.style == StyleType.PREVIEW) {
                attachmentDivider.setVisibility(0);
                attachmentText.setTextColor(-1);
            } else {
                ImageView attachmentDrawable = (ImageView)attachmentLayout.findViewById(R.id.attachment_icon);
                int baseColor = Injector.get().getIdentityStore().getAppConfig().getBaseColor();
                attachmentDrawable.setColorFilter(baseColor);
                attachmentText.setTextColor(baseColor);
            }
            if (i < count - 1) {
                attachmentLayout.setPadding(attachmentLayout.getPaddingLeft(), attachmentLayout.getPaddingTop(), attachmentLayout.getPaddingRight(), ScreenUtils.convertDpToPixel((float)12.0f, (Context)this.context));
            }
            layout2.addView((View)attachmentLayout);
        }
        BlockUtils.setLayoutMarginsAndGravity((View)layout2, 3, isLastObject);
        return layout2;
    }
}

