/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.attachments;

import android.annotation.TargetApi;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.attachments.AttachmentActivity;
import io.intercom.android.sdk.attachments.AttachmentData;
import io.intercom.android.sdk.utilities.EglUtils;
import io.intercom.android.sdk.utilities.ImageUtils;

@TargetApi(value=15)
public class AttachmentPresenter {
    private static final int MAX_UPLOAD_SIZE = 0x2800000;
    private final AttachmentActivity activity;
    private AttachmentData data;
    private boolean openGlEnabled = true;

    public AttachmentPresenter(AttachmentActivity activity) {
        this.activity = activity;
    }

    public void loadFile(Uri attachmentUri, boolean isHardwareAccelerated) {
        this.openGlEnabled = isHardwareAccelerated;
        new LoadFileTask().execute(new Uri[]{attachmentUri});
    }

    public void sendClicked() {
        if (this.data.getSize() == 0L) {
            this.activity.showDialog(this.activity.getResources().getString(R.string.intercomsdk_file_failed));
        } else if (this.data.getSize() >= 0x2800000L) {
            this.activity.showDialog(this.activity.getResources().getString(R.string.intercomsdk_file_too_big));
        } else {
            Intent output = new Intent();
            output.setData(this.data.getUri());
            this.activity.setResult(-1, output);
            this.activity.finish();
        }
    }

    public void cancelClicked() {
        this.activity.setResult(0);
        this.activity.finish();
    }

    public void imageFailedToLoad() {
        this.activity.displayAttachmentDetails(this.data.getFileName(), this.data.getSize(), this.findImageDrawable(this.data.getMimeType()));
    }

    private Drawable findImageDrawable(String mimeType) {
        Resources r = this.activity.getResources();
        Drawable drawable2 = mimeType.contains("image") ? r.getDrawable(R.drawable.intercom_image_attachment) : (mimeType.contains("video") ? r.getDrawable(R.drawable.intercom_video_attachment) : (mimeType.contains("audio") ? r.getDrawable(R.drawable.intercom_audio_attachment) : (mimeType.contains("zip") ? r.getDrawable(R.drawable.intercom_zip_attachment) : (mimeType.contains("text") || mimeType.contains("word") ? r.getDrawable(R.drawable.intercom_text_attachment) : (mimeType.contains("excel") || mimeType.contains("powerpoint") || mimeType.contains("xml") ? r.getDrawable(R.drawable.intercom_document_attachment) : (mimeType.contains("pdf") ? r.getDrawable(R.drawable.intercom_pdf_attachment) : r.getDrawable(R.drawable.intercom_general_attachment)))))));
        return drawable2;
    }

    private class LoadFileTask
    extends AsyncTask<Uri, Void, AttachmentData> {
        private LoadFileTask() {
        }

        protected AttachmentData doInBackground(Uri ... attachmentUri) {
            AttachmentData attachmentData;
            try {
                attachmentData = new AttachmentData(attachmentUri[0], "", AttachmentPresenter.this.activity);
            }
            catch (Exception e) {
                attachmentData = null;
            }
            return attachmentData;
        }

        protected void onPostExecute(AttachmentData data) {
            if (data == null) {
                AttachmentPresenter.this.activity.displayFailedAttachment();
            } else {
                AttachmentPresenter.this.data = data;
                int width = data.getImageWidth();
                int height = data.getImageHeight();
                int eglMaxTextureSize = EglUtils.getEGLMaxTextureSize();
                if (data.getMimeType().contains("image")) {
                    AttachmentPresenter.this.activity.displayImage(data.getFile(), ImageUtils.getBoundedWidth(width, height, eglMaxTextureSize, AttachmentPresenter.this.openGlEnabled), ImageUtils.getBoundedHeight(width, height, eglMaxTextureSize, AttachmentPresenter.this.openGlEnabled));
                } else {
                    AttachmentPresenter.this.activity.displayAttachmentDetails(data.getFileName(), data.getSize(), AttachmentPresenter.this.findImageDrawable(data.getMimeType()));
                }
                AttachmentPresenter.this.activity.enableSendButton();
            }
        }
    }
}

