/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.app.Application;
import android.content.Context;
import io.intercom.android.sdk.NexusWrapper;
import io.intercom.android.sdk.TeamPresenceProvider;
import io.intercom.android.sdk.UnreadCountTracker;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.DeDuper;
import io.intercom.android.sdk.api.MainThreadBus;
import io.intercom.android.sdk.identity.IdentityStore;
import io.intercom.android.sdk.lifecycles.Lifecycles;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.preview.PreviewManager;
import io.intercom.com.squareup.otto.Bus;
import io.intercom.com.squareup.otto.ThreadEnforcer;

public class Injector {
    private static Injector instance;
    private final Context appContext;
    private final MainThreadBus bus;
    private final NexusWrapper nexusClient;
    private final UnreadCountTracker unreadCountTracker;
    private final TeamPresenceProvider teamPresenceProvider;
    private final IdentityStore identityStore;
    private final DeDuper superDeDuper;
    private final Api api;
    private final MetricsStore metricsStore;
    private final PreviewManager previewManager;

    public static synchronized void init(Application application) {
        if (instance == null) {
            IdentityStore idStore = new IdentityStore((Context)application);
            Injector.initWithAppCredentials(application, idStore.getApiKey(), idStore.getAppId());
        }
    }

    public static synchronized void initWithAppCredentials(Application application, String apiKey, String appId) {
        if (instance == null) {
            IntercomLogger.internal(Injector.class.getSimpleName(), "Initializing");
            Context appContext = application.getApplicationContext();
            IdentityStore identityStore = new IdentityStore(appContext);
            identityStore.setAppIdentity(apiKey, appId);
            Api api = new Api(appContext, appId, !identityStore.hasIntercomid(), identityStore);
            DeDuper superDeDuper = new DeDuper(identityStore);
            MetricsStore metricsStore = new MetricsStore(appContext, api);
            metricsStore.loadCachedMetrics();
            Lifecycles lifecycles = new Lifecycles(api, superDeDuper, metricsStore);
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)lifecycles);
            MainThreadBus bus = new MainThreadBus(ThreadEnforcer.ANY);
            NexusWrapper nexusClient = new NexusWrapper(bus);
            nexusClient.setLoggingEnabled(false);
            instance = new Injector(appContext, bus, nexusClient, new UnreadCountTracker(), new TeamPresenceProvider(), identityStore, superDeDuper, api, metricsStore, new PreviewManager(application, bus));
        }
    }

    Injector(Context appContext, MainThreadBus bus, NexusWrapper nexusClient, UnreadCountTracker unreadCountTracker, TeamPresenceProvider teamPresenceProvider, IdentityStore identityStore, DeDuper superDeDuper, Api api, MetricsStore metricsStore, PreviewManager previewManager) {
        this.appContext = appContext;
        this.bus = bus;
        this.nexusClient = nexusClient;
        this.unreadCountTracker = unreadCountTracker;
        this.teamPresenceProvider = teamPresenceProvider;
        this.identityStore = identityStore;
        this.superDeDuper = superDeDuper;
        this.api = api;
        this.metricsStore = metricsStore;
        this.previewManager = previewManager;
    }

    public static Injector get() {
        return instance;
    }

    static void setSharedInstance(Injector injector) {
        instance = injector;
    }

    public Context getContext() {
        return this.appContext;
    }

    public Bus getBus() {
        return this.bus;
    }

    public NexusWrapper getNexusClient() {
        return this.nexusClient;
    }

    public UnreadCountTracker getUnreadCountTracker() {
        return this.unreadCountTracker;
    }

    public TeamPresenceProvider getTeamPresenceProvider() {
        return this.teamPresenceProvider;
    }

    public IdentityStore getIdentityStore() {
        return this.identityStore;
    }

    public DeDuper getDeDuper() {
        return this.superDeDuper;
    }

    public Api getApi() {
        this.api.configureRequestSynchronicity(this.appContext, this.identityStore.hasIntercomid());
        return this.api;
    }

    public MetricsStore getMetricsStore() {
        return this.metricsStore;
    }

    public PreviewManager getPreviewManager() {
        return this.previewManager;
    }
}

