/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import io.intercom.android.sdk.logger.IntercomLogger;

public class Gcm {
    public static final String MULTIPLE_NOTIFICATIONS = "multiple_notifications";
    public static final String ACTION_REMOVE_NOTIFICATION = "intercom_sdk_remove_notification";
    public static final String PUSH_ONLY_ID = "push_only_convo_id";

    public static void clearNotifications(Context context) {
        Class intentClass = Gcm.getGcmIntentClass();
        if (intentClass != null) {
            Intent intent = new Intent(context, intentClass);
            intent.setAction(ACTION_REMOVE_NOTIFICATION);
            context.startService(intent);
        }
    }

    public static void changeComponentState(int newState, Context context) {
        Class broadcastReceiverClass = Gcm.getGcmBroadcastReceiverClass();
        Class intentClass = Gcm.getGcmIntentClass();
        if (broadcastReceiverClass != null && intentClass != null) {
            ComponentName gcmBroadcastReceiverComponent = new ComponentName(context, broadcastReceiverClass);
            ComponentName gcmServiceComponent = new ComponentName(context, intentClass);
            PackageManager packageManager = context.getPackageManager();
            packageManager.setComponentEnabledSetting(gcmBroadcastReceiverComponent, newState, 1);
            packageManager.setComponentEnabledSetting(gcmServiceComponent, newState, 1);
            IntercomLogger.internal("component state", "broadcast receiver is enabled: " + (packageManager.getComponentEnabledSetting(gcmBroadcastReceiverComponent) == 1));
            IntercomLogger.internal("component state", "gcm service is enabled: " + (packageManager.getComponentEnabledSetting(gcmServiceComponent) == 1));
        }
    }

    public static boolean gcmModuleInstalled() {
        return Gcm.getGcmIntentClass() != null && Gcm.getGcmBroadcastReceiverClass() != null;
    }

    public static boolean isGcmEnabled(Context context) {
        Class broadcastReceiverClass = Gcm.getGcmBroadcastReceiverClass();
        Class intentClass = Gcm.getGcmIntentClass();
        if (broadcastReceiverClass != null && intentClass != null) {
            PackageManager packageManager = context.getPackageManager();
            ComponentName gcmBroadcastReceiverComponent = new ComponentName(context, broadcastReceiverClass);
            ComponentName gcmServiceComponent = new ComponentName(context, intentClass);
            return packageManager.getComponentEnabledSetting(gcmBroadcastReceiverComponent) == 1 && packageManager.getComponentEnabledSetting(gcmServiceComponent) == 1;
        }
        return false;
    }

    private static Class getGcmIntentClass() {
        try {
            return Class.forName("io.intercom.android.sdk.gcm.GcmIntentService");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Class getGcmBroadcastReceiverClass() {
        try {
            return Class.forName("io.intercom.android.sdk.gcm.GcmBroadcastReceiver");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

