/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.widget.LinearLayout;
import androidx.annotation.LayoutRes;
import androidx.annotation.Nullable;
import com.google.gson.Gson;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.blocks.Attachment;
import io.intercom.android.sdk.blocks.Button;
import io.intercom.android.sdk.blocks.ButtonClickListener;
import io.intercom.android.sdk.blocks.Code;
import io.intercom.android.sdk.blocks.ConversationRatingCard;
import io.intercom.android.sdk.blocks.Heading;
import io.intercom.android.sdk.blocks.ImageClickListener;
import io.intercom.android.sdk.blocks.ImageText;
import io.intercom.android.sdk.blocks.LinkCard;
import io.intercom.android.sdk.blocks.LinkListRenderer;
import io.intercom.android.sdk.blocks.ListBlock;
import io.intercom.android.sdk.blocks.LocalImage;
import io.intercom.android.sdk.blocks.NetworkImage;
import io.intercom.android.sdk.blocks.Paragraph;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.UploadingImageCache;
import io.intercom.android.sdk.blocks.Video;
import io.intercom.android.sdk.blocks.VideoFile;
import io.intercom.android.sdk.blocks.lib.BlockType;
import io.intercom.android.sdk.blocks.lib.Blocks;
import io.intercom.android.sdk.blocks.lib.BlocksViewHolder;
import io.intercom.android.sdk.blocks.lib.models.Block;
import io.intercom.android.sdk.blocks.lib.models.BlockAttachment;
import io.intercom.android.sdk.blocks.messengercard.MessengerCard;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.Attachments;
import io.intercom.android.sdk.models.Part;
import java.util.ArrayList;
import java.util.List;

public class ViewHolderGenerator {
    private final UploadingImageCache uploadingImageCache;
    private final Api api;
    private final Provider<AppConfig> appConfigProvider;
    private final String conversationId;
    @Nullable
    private final ImageClickListener imageListener;
    @Nullable
    private final ButtonClickListener buttonClickListener;
    private final Gson gson;
    private final MetricTracker metricTracker;

    public ViewHolderGenerator(UploadingImageCache uploadingImageCache, Api api, Provider<AppConfig> appConfigProvider, String conversationId2, @Nullable ImageClickListener imageListener, @Nullable ButtonClickListener buttonClickListener, Gson gson, MetricTracker metricTracker) {
        this.uploadingImageCache = uploadingImageCache;
        this.api = api;
        this.appConfigProvider = appConfigProvider;
        this.conversationId = conversationId2;
        this.imageListener = imageListener;
        this.buttonClickListener = buttonClickListener;
        this.gson = gson;
        this.metricTracker = metricTracker;
    }

    public BlocksViewHolder getAdminHolder() {
        return this.generateHolder(R.layout.intercom_blocks_admin_layout, StyleType.ADMIN);
    }

    public BlocksViewHolder getUserHolder() {
        return this.generateHolder(R.layout.intercom_blocks_user_layout, StyleType.USER);
    }

    public BlocksViewHolder getPreviewHolder() {
        return this.generateHolder(R.layout.intercom_blocks_user_layout, StyleType.PREVIEW);
    }

    public BlocksViewHolder getPostHolder() {
        return this.generateHolder(R.layout.intercom_blocks_container_layout, StyleType.POST);
    }

    public BlocksViewHolder getNoteHolder() {
        return this.generateHolder(R.layout.intercom_blocks_note_layout, StyleType.NOTE);
    }

    public BlocksViewHolder getArticleHolder() {
        return this.generateHolder(R.layout.intercom_blocks_article_layout, StyleType.ARTICLE);
    }

    public BlocksViewHolder getContainerCardHolder() {
        return this.generateHolder(R.layout.intercom_blocks_container_card_layout, StyleType.CONTAINER_CARD);
    }

    public BlocksViewHolder getChatFullHolder() {
        return this.generateHolder(R.layout.intercom_blocks_admin_layout, StyleType.CHAT_FULL);
    }

    public BlocksViewHolder getLinkHolder() {
        return this.generateHolder(R.layout.intercom_blocks_container_layout, StyleType.CHAT_FULL);
    }

    public BlocksViewHolder getConversationRatingHolder() {
        return this.generateHolder(R.layout.intercom_blocks_container_layout, StyleType.CHAT_FULL);
    }

    public BlocksViewHolder getLinkListHolder() {
        return this.generateHolder(R.layout.intercom_blocks_container_card_layout, StyleType.CHAT_FULL);
    }

    public BlocksViewHolder getCarouselHolder() {
        return this.generateHolder(R.layout.intercom_blocks_carousel_layout, StyleType.CAROUSEL);
    }

    private BlocksViewHolder generateHolder(@LayoutRes int layoutId, StyleType style) {
        BlocksViewHolder holder = new BlocksViewHolder();
        Button button = new Button(style, this.appConfigProvider, this.buttonClickListener);
        Heading heading = new Heading(style, this.appConfigProvider);
        ListBlock list = new ListBlock(style, this.appConfigProvider);
        Attachment attachment = new Attachment(style, this.appConfigProvider);
        holder.setLayout(layoutId);
        holder.setParagraph(new Paragraph(style, this.appConfigProvider));
        holder.setHeading(heading);
        holder.setSubheading(heading);
        holder.setCode(new Code());
        holder.setUnorderedList(list);
        holder.setOrderedList(list);
        holder.setImage(new NetworkImage(style, this.uploadingImageCache, this.imageListener));
        holder.setLocalImage(new LocalImage(style));
        holder.setButton(button);
        holder.setAttachmentList(attachment);
        holder.setLocalAttachment(attachment);
        holder.setTwitterButton(button);
        holder.setFacebookButton(button);
        holder.setVideo(new Video(style, this.api));
        holder.setVideoFile(new VideoFile(style, this.appConfigProvider, this.metricTracker));
        holder.setLink(new LinkCard(style, this.appConfigProvider, this.conversationId));
        holder.setConversationRating(new ConversationRatingCard(this.api, this.conversationId, this.appConfigProvider));
        holder.setLinkList(new LinkListRenderer(this.api, this.appConfigProvider, this.conversationId));
        holder.setImageText(new ImageText(style, this.uploadingImageCache));
        if (!style.equals((Object)StyleType.CHAT_FULL)) {
            holder.setMessengerCardBlock(new MessengerCard(this.appConfigProvider, this.gson, this.metricTracker, this.conversationId));
        }
        return holder;
    }

    public static LinearLayout createPartsLayout(BlocksViewHolder blocksNoteViewHolder, Part part, Context context) {
        List<Block> blockParts = part.getBlocks();
        if (!part.getAttachments().isEmpty()) {
            ArrayList<BlockAttachment> blockAttachments = new ArrayList<BlockAttachment>();
            for (Attachments attachment : part.getAttachments()) {
                blockAttachments.add(new BlockAttachment.Builder().withName(attachment.getName()).withUrl(attachment.getUrl()).build());
            }
            Block attachmentBlock = new Block.Builder().withType(BlockType.ATTACHMENTLIST.name()).withAttachments(blockAttachments).build();
            blockParts.add(attachmentBlock);
        }
        Blocks blocks2 = new Blocks(context, LumberMill.getBlocksTwig());
        return blocks2.createBlocks(blockParts, blocksNoteViewHolder);
    }

    public static LinearLayout createLayoutFromBlocks(BlocksViewHolder blocksNoteViewHolder, List<Block> blockParts, Context context) {
        Blocks blocks2 = new Blocks(context, LumberMill.getBlocksTwig());
        return blocks2.createBlocks(blockParts, blocksNoteViewHolder);
    }
}

