/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import io.intercom.android.sdk.api.AutoValue_UserUpdateRequest;
import java.util.HashMap;
import java.util.Map;

@AutoValue
public abstract class UserUpdateRequest {
    public static UserUpdateRequest create(boolean newSession, boolean sentFromBackground, @Nullable Map<String, Object> attributes, boolean internalUpdate) {
        return new Builder().isNewSession(newSession).isSentFromBackground(sentFromBackground).withAttributes(attributes).isInternalUpdate(internalUpdate).build();
    }

    public static UserUpdateRequest create(boolean newSession, boolean sentFromBackground, boolean internalUpdate) {
        return UserUpdateRequest.create(newSession, sentFromBackground, null, internalUpdate);
    }

    public abstract boolean isNewSession();

    public abstract boolean isSentFromBackground();

    public abstract boolean isInternalUpdate();

    public abstract Map<String, Object> getAttributes();

    public boolean isValidUpdate() {
        return this.isInternalUpdate() || !this.getAttributes().isEmpty();
    }

    public static final class Builder {
        boolean isNewSession = false;
        boolean isSentFromBackground = true;
        boolean isInternalUpdate = false;
        @Nullable
        Map<String, Object> attributes;

        public Builder isNewSession(boolean isNewSession) {
            this.isNewSession = isNewSession;
            return this;
        }

        public Builder isSentFromBackground(boolean isSentFromBackground) {
            this.isSentFromBackground = isSentFromBackground;
            return this;
        }

        public Builder isInternalUpdate(boolean isInternalUpdate) {
            this.isInternalUpdate = isInternalUpdate;
            return this;
        }

        public Builder withAttributes(@Nullable Map<String, Object> attributes) {
            this.attributes = attributes;
            return this;
        }

        public UserUpdateRequest build() {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            if (this.attributes != null) {
                attributes.putAll(this.attributes);
            }
            return new AutoValue_UserUpdateRequest(this.isNewSession, this.isSentFromBackground, this.isInternalUpdate, attributes);
        }
    }
}

