/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.conversation.data;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.gson.Gson;
import io.intercom.android.nexus.NexusClient;
import io.intercom.android.sdk.AblyManager;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.IntercomError;
import io.intercom.android.sdk.IntercomStatusCallback;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.MessengerApi;
import io.intercom.android.sdk.api.MessengerApiHelper;
import io.intercom.android.sdk.api.UserUpdateRequest;
import io.intercom.android.sdk.blocks.lib.models.Block;
import io.intercom.android.sdk.helpcenter.utils.networking.NetworkResponse;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.m5.conversation.data.CombinedEventAsFlowKt;
import io.intercom.android.sdk.m5.conversation.data.GetConversationReason;
import io.intercom.android.sdk.m5.conversation.data.NexusEventsRepository;
import io.intercom.android.sdk.m5.conversation.data.ParsedNexusEvent;
import io.intercom.android.sdk.m5.conversation.ui.components.composer.MediaData;
import io.intercom.android.sdk.m5.conversation.utils.audio.AudioRequestBody;
import io.intercom.android.sdk.m5.upload.data.UploadRepository;
import io.intercom.android.sdk.models.ComposerSuggestions;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.ConversationResponse;
import io.intercom.android.sdk.models.GifResponse;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.TranscribedText;
import io.intercom.android.sdk.models.Upload;
import io.intercom.android.sdk.utilities.TimeFormatterExtKt;
import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001BK\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0!J<\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\b\u0010-\u001a\u0004\u0018\u00010.H\u0086@\u00a2\u0006\u0002\u0010/Jl\u00100\u001a\b\u0012\u0004\u0012\u0002010%2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\b\u00102\u001a\u0004\u0018\u00010(2\b\u00103\u001a\u0004\u0018\u00010(2\b\u00104\u001a\u0004\u0018\u00010(2\u000e\u00105\u001a\n\u0012\u0004\u0012\u000206\u0018\u00010+2\b\u00107\u001a\u0004\u0018\u00010.2\b\u00108\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020(H\u0086@\u00a2\u0006\u0002\u00109J$\u0010:\u001a\b\u0012\u0004\u0012\u00020;0%2\u0006\u0010'\u001a\u00020(2\u0006\u0010<\u001a\u00020=H\u0086@\u00a2\u0006\u0002\u0010>J&\u0010?\u001a\b\u0012\u0004\u0012\u00020;0%2\u0006\u0010@\u001a\u00020(2\b\u00108\u001a\u0004\u0018\u00010(H\u0086@\u00a2\u0006\u0002\u0010AJ4\u0010B\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010C\u001a\u00020(2\u0006\u0010'\u001a\u00020(2\u0006\u0010D\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0086@\u00a2\u0006\u0002\u0010EJ\u0016\u0010F\u001a\u00020G2\u0006\u0010'\u001a\u00020(H\u0086@\u00a2\u0006\u0002\u0010HJ\u001c\u0010I\u001a\b\u0012\u0004\u0012\u00020J0%2\u0006\u0010K\u001a\u00020(H\u0086@\u00a2\u0006\u0002\u0010HJ\u001c\u0010L\u001a\b\u0012\u0004\u0012\u00020M0%2\u0006\u0010N\u001a\u00020OH\u0086@\u00a2\u0006\u0002\u0010PJ<\u0010Q\u001a\b\u0012\u0004\u0012\u00020;0%2\u0006\u0010'\u001a\u00020(2\u0006\u0010R\u001a\u00020(2\u0006\u0010S\u001a\u00020(2\u0006\u0010T\u001a\u00020(2\u0006\u0010U\u001a\u00020(H\u0086@\u00a2\u0006\u0002\u0010VJ\u001c\u0010W\u001a\b\u0012\u0004\u0012\u00020X0%2\u0006\u0010Y\u001a\u00020ZH\u0086@\u00a2\u0006\u0002\u0010[J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\\\u001a\u00020GJ!\u0010]\u001a\u00020G2\u0006\u0010'\u001a\u00020(2\f\u0010^\u001a\b\u0012\u0004\u0012\u00020(0_\u00a2\u0006\u0002\u0010`R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006a"}, d2={"Lio/intercom/android/sdk/m5/conversation/data/ConversationRepository;", "", "messengerApi", "Lio/intercom/android/sdk/api/MessengerApi;", "uploadRepository", "Lio/intercom/android/sdk/m5/upload/data/UploadRepository;", "api", "Lio/intercom/android/sdk/api/Api;", "userIdentity", "Lio/intercom/android/sdk/identity/UserIdentity;", "ablyManager", "Lio/intercom/android/sdk/AblyManager;", "nexusClient", "Lio/intercom/android/nexus/NexusClient;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lio/intercom/android/sdk/api/MessengerApi;Lio/intercom/android/sdk/m5/upload/data/UploadRepository;Lio/intercom/android/sdk/api/Api;Lio/intercom/android/sdk/identity/UserIdentity;Lio/intercom/android/sdk/AblyManager;Lio/intercom/android/nexus/NexusClient;Lkotlinx/coroutines/CoroutineScope;)V", "getMessengerApi", "()Lio/intercom/android/sdk/api/MessengerApi;", "getApi", "()Lio/intercom/android/sdk/api/Api;", "getUserIdentity", "()Lio/intercom/android/sdk/identity/UserIdentity;", "getAblyManager", "()Lio/intercom/android/sdk/AblyManager;", "nexusEventsRepository", "Lio/intercom/android/sdk/m5/conversation/data/NexusEventsRepository;", "getNexusEventsRepository", "()Lio/intercom/android/sdk/m5/conversation/data/NexusEventsRepository;", "nexusEventsRepository$delegate", "Lkotlin/Lazy;", "nexusEventFlow", "Lkotlinx/coroutines/flow/Flow;", "Lio/intercom/android/sdk/m5/conversation/data/ParsedNexusEvent;", "realTimeEvents", "replyToConversation", "Lio/intercom/android/sdk/helpcenter/utils/networking/NetworkResponse;", "Lio/intercom/android/sdk/models/Part$Builder;", "conversationId", "", "clientUUID", "blocks", "", "Lio/intercom/android/sdk/blocks/lib/models/Block$Builder;", "lastAdminPartCreatedAt", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/Long;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createNewConversation", "Lio/intercom/android/sdk/models/ConversationResponse$Builder;", "botIntroId", "articleId", "botBehaviourId", "suggestions", "Lio/intercom/android/sdk/models/ComposerSuggestions$Suggestion;", "snapshotId", "openRequestId", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/Long;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getConversation", "Lio/intercom/android/sdk/models/Conversation;", "reason", "Lio/intercom/android/sdk/m5/conversation/data/GetConversationReason;", "(Ljava/lang/String;Lio/intercom/android/sdk/m5/conversation/data/GetConversationReason;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createConversationFromSuggestion", "suggestionId", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addQuickReplyToConversation", "quickReplyId", "quickReplyPartId", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "markAsRead", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadGifs", "Lio/intercom/android/sdk/models/GifResponse;", "searchQuery", "uploadMedia", "Lio/intercom/android/sdk/models/Upload$Builder;", "imageData", "Lio/intercom/android/sdk/m5/conversation/ui/components/composer/MediaData$Media;", "(Lio/intercom/android/sdk/m5/conversation/ui/components/composer/MediaData$Media;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "submitForm", "partId", "identifier", "formValue", "formType", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "transcribe", "Lio/intercom/android/sdk/models/TranscribedText;", "audioFile", "Ljava/io/File;", "(Ljava/io/File;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dismissPrivacyPolicy", "recordInteractions", "interactions", "", "(Ljava/lang/String;[Ljava/lang/String;)V", "intercom-sdk-base_release"})
@StabilityInferred(parameters=0)
public final class ConversationRepository {
    @NotNull
    private final MessengerApi messengerApi;
    @NotNull
    private final UploadRepository uploadRepository;
    @NotNull
    private final Api api;
    @NotNull
    private final UserIdentity userIdentity;
    @NotNull
    private final AblyManager ablyManager;
    @NotNull
    private final NexusClient nexusClient;
    @NotNull
    private final Lazy nexusEventsRepository$delegate;
    @NotNull
    private final Flow<ParsedNexusEvent> nexusEventFlow;
    public static final int $stable = 8;

    public ConversationRepository(@NotNull MessengerApi messengerApi, @NotNull UploadRepository uploadRepository, @NotNull Api api, @NotNull UserIdentity userIdentity, @NotNull AblyManager ablyManager, @NotNull NexusClient nexusClient, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)messengerApi, (String)"messengerApi");
        Intrinsics.checkNotNullParameter((Object)uploadRepository, (String)"uploadRepository");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        Intrinsics.checkNotNullParameter((Object)userIdentity, (String)"userIdentity");
        Intrinsics.checkNotNullParameter((Object)ablyManager, (String)"ablyManager");
        Intrinsics.checkNotNullParameter((Object)nexusClient, (String)"nexusClient");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.messengerApi = messengerApi;
        this.uploadRepository = uploadRepository;
        this.api = api;
        this.userIdentity = userIdentity;
        this.ablyManager = ablyManager;
        this.nexusClient = nexusClient;
        this.nexusEventsRepository$delegate = LazyKt.lazy(() -> ConversationRepository.nexusEventsRepository_delegate$lambda$0(this, scope));
        this.nexusEventFlow = CombinedEventAsFlowKt.combinedEventAsFlow(this.nexusClient, this.ablyManager);
    }

    public /* synthetic */ ConversationRepository(MessengerApi messengerApi, UploadRepository uploadRepository, Api api, UserIdentity userIdentity, AblyManager ablyManager, NexusClient nexusClient, CoroutineScope coroutineScope, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            messengerApi = Injector.get().getMessengerApi();
        }
        if ((n & 2) != 0) {
            uploadRepository = new UploadRepository(null, null, null, null, 15, null);
        }
        if ((n & 4) != 0) {
            api = Injector.get().getApi();
        }
        if ((n & 8) != 0) {
            userIdentity = Injector.get().getUserIdentity();
        }
        if ((n & 0x10) != 0) {
            ablyManager = Injector.get().getAblyManager();
        }
        if ((n & 0x20) != 0) {
            nexusClient = Injector.get().getNexusClient();
        }
        this(messengerApi, uploadRepository, api, userIdentity, ablyManager, nexusClient, coroutineScope);
    }

    @NotNull
    public final MessengerApi getMessengerApi() {
        return this.messengerApi;
    }

    @NotNull
    public final Api getApi() {
        return this.api;
    }

    @NotNull
    public final UserIdentity getUserIdentity() {
        return this.userIdentity;
    }

    @NotNull
    public final AblyManager getAblyManager() {
        return this.ablyManager;
    }

    private final NexusEventsRepository getNexusEventsRepository() {
        Lazy lazy = this.nexusEventsRepository$delegate;
        return (NexusEventsRepository)lazy.getValue();
    }

    @NotNull
    public final Flow<ParsedNexusEvent> realTimeEvents() {
        return this.nexusEventFlow;
    }

    @Nullable
    public final Object replyToConversation(@NotNull String conversationId2, @NotNull String clientUUID, @NotNull List<Block.Builder> blocks2, @Nullable Long lastAdminPartCreatedAt, @NotNull Continuation<? super NetworkResponse<Part.Builder>> $completion) {
        Map<String, Object> map2;
        Map<String, Object> $this$replyToConversation_u24lambda_u242 = map2 = this.api.createBaseReplyParams();
        boolean bl = false;
        $this$replyToConversation_u24lambda_u242.put("blocks", blocks2);
        $this$replyToConversation_u24lambda_u242.put("client_assigned_uuid", clientUUID);
        Long l = lastAdminPartCreatedAt;
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl2 = false;
            $this$replyToConversation_u24lambda_u242.put("last_admin_part_created_at", TimeFormatterExtKt.toISOFormat(lastAdminPartCreatedAt));
        }
        Map<String, Object> params = map2;
        Intrinsics.checkNotNull(params);
        RequestBody requestBody = MessengerApiHelper.INSTANCE.getDefaultRequestBody$intercom_sdk_base_release(params);
        return this.messengerApi.replyToConversationSuspend(conversationId2, requestBody, $completion);
    }

    @Nullable
    public final Object createNewConversation(@NotNull List<Block.Builder> blocks2, @Nullable String botIntroId, @Nullable String articleId, @Nullable String botBehaviourId, @Nullable List<ComposerSuggestions.Suggestion> suggestions, @Nullable Long snapshotId, @Nullable String openRequestId, @NotNull String clientUUID, @NotNull Continuation<? super NetworkResponse<ConversationResponse.Builder>> $completion) {
        Map<String, Object> map2;
        Map<String, Object> $this$createNewConversation_u24lambda_u243 = map2 = this.api.baseNewConversationParams();
        boolean bl = false;
        $this$createNewConversation_u24lambda_u243.put("blocks", blocks2);
        $this$createNewConversation_u24lambda_u243.put("client_assigned_uuid", clientUUID);
        if (botIntroId != null) {
            $this$createNewConversation_u24lambda_u243.put("bot_intro", botIntroId);
        }
        if (articleId != null) {
            $this$createNewConversation_u24lambda_u243.put("article_id", articleId);
        }
        if (botBehaviourId != null) {
            $this$createNewConversation_u24lambda_u243.put("resolution_bot_behavior_version_id", botBehaviourId);
        }
        if (suggestions != null) {
            $this$createNewConversation_u24lambda_u243.put("composer_suggestions", new Gson().toJson(suggestions));
        }
        if (snapshotId != null) {
            $this$createNewConversation_u24lambda_u243.put("snapshot_id", snapshotId);
        }
        if (openRequestId != null) {
            $this$createNewConversation_u24lambda_u243.put("messenger_open_request_id", openRequestId);
        }
        Map<String, Object> params = map2;
        Intrinsics.checkNotNull(params);
        RequestBody requestBody = MessengerApiHelper.INSTANCE.getDefaultRequestBody$intercom_sdk_base_release(params);
        return this.messengerApi.startNewConversationSuspend(requestBody, $completion);
    }

    @Nullable
    public final Object getConversation(@NotNull String conversationId2, @NotNull GetConversationReason reason, @NotNull Continuation<? super NetworkResponse<Conversation>> $completion) {
        String string2;
        switch (WhenMappings.$EnumSwitchMapping$0[reason.ordinal()]) {
            case 1: {
                string2 = "Nexus New Comment";
                break;
            }
            case 2: {
                string2 = "Nexus Reconnected";
                break;
            }
            case 3: {
                string2 = "Internet Reconnected";
                break;
            }
            case 4: {
                string2 = "Click Conversation";
                break;
            }
            case 5: {
                string2 = "State Sync";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String reasonString = string2;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"request_origin", (Object)reasonString)};
        Map params = MapsKt.mutableMapOf((Pair[])pairArray);
        if (reason == GetConversationReason.POLLING) {
            params.put("sync", "true");
        }
        RequestBody requestBody = MessengerApiHelper.INSTANCE.getDefaultRequestBody$intercom_sdk_base_release(params);
        return this.messengerApi.getConversationSuspend(conversationId2, requestBody, $completion);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object createConversationFromSuggestion(@NotNull String suggestionId, @Nullable String openRequestId, @NotNull Continuation<? super NetworkResponse<Conversation>> $completion) {
        void $this$createConversationFromSuggestion_u24lambda_u244;
        Map map2;
        Map map3 = map2 = MapsKt.createMapBuilder();
        MessengerApiHelper messengerApiHelper = MessengerApiHelper.INSTANCE;
        boolean bl = false;
        $this$createConversationFromSuggestion_u24lambda_u244.put("id", suggestionId);
        if (openRequestId != null) {
            $this$createConversationFromSuggestion_u24lambda_u244.put("messenger_open_request_id", openRequestId);
        }
        RequestBody requestBody = messengerApiHelper.getDefaultRequestBody$intercom_sdk_base_release(MapsKt.build((Map)map2));
        return this.messengerApi.triggerInboundConversationSuspend(requestBody, $completion);
    }

    @Nullable
    public final Object addQuickReplyToConversation(@NotNull String quickReplyId, @NotNull String conversationId2, @NotNull String quickReplyPartId, @NotNull String clientUUID, @NotNull Continuation<? super NetworkResponse<Part.Builder>> $completion) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"reply_option_uuid", (Object)quickReplyId), TuplesKt.to((Object)"client_assigned_uuid", (Object)clientUUID)};
        Map params = MapsKt.mutableMapOf((Pair[])pairArray);
        if (((CharSequence)quickReplyPartId).length() > 0) {
            params.put("quick_reply_part_id", quickReplyPartId);
        }
        RequestBody requestBody = MessengerApiHelper.INSTANCE.getDefaultRequestBody$intercom_sdk_base_release(params);
        return this.messengerApi.addConversationQuickReplySuspend(conversationId2, requestBody, $completion);
    }

    @Nullable
    public final Object markAsRead(@NotNull String conversationId2, @NotNull Continuation<? super Unit> $completion) {
        RequestBody requestBody = MessengerApiHelper.INSTANCE.getDefaultRequestBody$intercom_sdk_base_release(MapsKt.mapOf((Pair)TuplesKt.to((Object)"app_id", (Object)Injector.get().getAppIdentity().appId())));
        Object object = this.messengerApi.markAsReadSuspend(conversationId2, requestBody, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object loadGifs(@NotNull String searchQuery, @NotNull Continuation<? super NetworkResponse<? extends GifResponse>> $completion) {
        Map map2 = !StringsKt.isBlank((CharSequence)searchQuery) ? MapsKt.mapOf((Pair)TuplesKt.to((Object)"query", (Object)searchQuery)) : MapsKt.emptyMap();
        RequestBody requestBody = MessengerApiHelper.INSTANCE.getDefaultRequestBody$intercom_sdk_base_release(map2);
        return this.messengerApi.getGifsSuspended(requestBody, $completion);
    }

    @Nullable
    public final Object uploadMedia(@NotNull MediaData.Media imageData, @NotNull Continuation<? super NetworkResponse<Upload.Builder>> $completion) {
        return this.uploadRepository.uploadFile(imageData, $completion);
    }

    @Nullable
    public final Object submitForm(@NotNull String conversationId2, @NotNull String partId, @NotNull String identifier, @NotNull String formValue, @NotNull String formType, @NotNull Continuation<? super NetworkResponse<Conversation>> $completion) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"conversation_part_id", (Object)partId), TuplesKt.to((Object)"identifier", (Object)identifier), TuplesKt.to((Object)"value", (Object)formValue), TuplesKt.to((Object)"type", (Object)formType)};
        Map params = MapsKt.mapOf((Pair[])pairArray);
        RequestBody requestBody = MessengerApiHelper.INSTANCE.getDefaultRequestBody$intercom_sdk_base_release(MapsKt.mapOf((Pair)TuplesKt.to((Object)"form_params", (Object)params)));
        return this.messengerApi.submitFormSuspend(conversationId2, requestBody, $completion);
    }

    @Nullable
    public final Object transcribe(@NotNull File audioFile, @NotNull Continuation<? super NetworkResponse<TranscribedText>> $completion) {
        String string2;
        Map userData;
        String string3 = this.userIdentity.getEmail();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getEmail(...)");
        if (!(((CharSequence)string3).length() == 0)) {
            Map map2;
            Map $this$transcribe_u24lambda_u245 = map2 = MapsKt.createMapBuilder();
            boolean bl = false;
            String string4 = this.userIdentity.getEmail();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getEmail(...)");
            $this$transcribe_u24lambda_u245.put("email", string4);
            String string5 = this.userIdentity.getUserId();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getUserId(...)");
            if (!(((CharSequence)string5).length() == 0)) {
                String string6 = this.userIdentity.getUserId();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getUserId(...)");
                $this$transcribe_u24lambda_u245.put("user_id", string6);
            }
            userData = MapsKt.build((Map)map2);
            string2 = new Gson().toJson((Object)userData);
        } else {
            userData = MapsKt.mapOf((Pair)TuplesKt.to((Object)"anonymous_id", (Object)this.userIdentity.getAnonymousId()));
            string2 = new Gson().toJson((Object)userData);
        }
        String userDataJson = string2;
        AudioRequestBody audioRequestBody = new AudioRequestBody(audioFile);
        MultipartBody.Part audioPart = MultipartBody.Part.Companion.createFormData("audio", audioFile.getName(), (RequestBody)audioRequestBody);
        Intrinsics.checkNotNull((Object)userDataJson);
        MultipartBody.Part userDataPart = MultipartBody.Part.Companion.createFormData("user_data", userDataJson);
        String appId = Injector.get().getAppIdentity().appId();
        Intrinsics.checkNotNull((Object)appId);
        MultipartBody.Part appIdPart = MultipartBody.Part.Companion.createFormData("app_id", appId);
        List<MultipartBody.Part> defaultFields = MessengerApiHelper.INSTANCE.getDefaultMultipartFields$intercom_sdk_base_release();
        return this.messengerApi.transcribeSuspend(audioPart, userDataPart, appIdPart, defaultFields, $completion);
    }

    @NotNull
    public final NexusEventsRepository nexusEventsRepository() {
        return this.getNexusEventsRepository();
    }

    public final void dismissPrivacyPolicy() {
        Map attributes = MapsKt.mapOf((Pair)TuplesKt.to((Object)"dismissed_privacy_policy_notice_at", (Object)(System.currentTimeMillis() / (long)1000)));
        this.api.updateUser(UserUpdateRequest.create(false, false, attributes, true), new IntercomStatusCallback(){

            public void onSuccess() {
            }

            public void onFailure(IntercomError intercomError) {
                Intrinsics.checkNotNullParameter((Object)intercomError, (String)"intercomError");
            }
        });
    }

    public final void recordInteractions(@NotNull String conversationId2, @NotNull String[] interactions) {
        Intrinsics.checkNotNullParameter((Object)conversationId2, (String)"conversationId");
        Intrinsics.checkNotNullParameter((Object)interactions, (String)"interactions");
        this.api.recordInteractions(conversationId2, interactions);
    }

    private static final NexusEventsRepository nexusEventsRepository_delegate$lambda$0(ConversationRepository this$0, CoroutineScope $scope) {
        return new NexusEventsRepository(this$0.nexusClient, this$0.userIdentity, $scope);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GetConversationReason.values().length];
            try {
                nArray[GetConversationReason.NEW_COMMENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GetConversationReason.NEXUS_CONNECTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GetConversationReason.NETWORK_CONNECTED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GetConversationReason.OPEN_CONVERSATION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GetConversationReason.POLLING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

