/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import io.intercom.android.sdk.IntercomStatusCallback;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.UserUpdateRequest;
import io.intercom.android.sdk.m5.data.IntercomDataLayer;
import io.intercom.android.sdk.metrics.ops.OpsMetricTracker;

public class UserUpdater {
    private final Provider<Api> apiProvider;
    private final IntercomDataLayer dataLayer;
    private OpsMetricTracker opsMetricTracker;

    public UserUpdater(Provider<Api> apiProvider, OpsMetricTracker opsMetricTracker, IntercomDataLayer dataLayer) {
        this.apiProvider = apiProvider;
        this.opsMetricTracker = opsMetricTracker;
        this.dataLayer = dataLayer;
    }

    public synchronized void updateUser(UserUpdateRequest userUpdateRequest, IntercomStatusCallback intercomStatusCallback) {
        this.opsMetricTracker.trackEvent("start", "time-to-complete-ping-ms");
        if (!userUpdateRequest.isValidUpdate()) {
            return;
        }
        if (userUpdateRequest.isNewSession()) {
            this.dataLayer.updateSessionStarted();
        }
        this.apiProvider.get().updateUser(userUpdateRequest, intercomStatusCallback);
    }
}

